/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.config.diff.zip;

import com.top_logic.basic.Configuration;
import com.top_logic.basic.Logger;
import com.top_logic.basic.Settings;
import com.top_logic.basic.StringServices;
import com.top_logic.basic.config.ExternallyNamed;
import com.top_logic.basic.io.BOMAwareReader;
import com.top_logic.basic.io.StreamUtilities;
import com.top_logic.config.diff.CompareStatistics;
import com.top_logic.config.diff.RootCompareStatistic;
import com.top_logic.knowledge.wrap.Document;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipReader {
    public static final String SEPARATOR = "/";
    public static final String ENCODING = Configuration.getConfiguration(ZipReader.class).getValue("DefaultEncoding", "UTF-8");
    private RootCompareStatistic.CompareExecutedListener listener = null;

    public void setListener(RootCompareStatistic.CompareExecutedListener aCLE) {
        this.listener = aCLE;
    }

    public Map<String, ZipEntry> readEntries(ZipFile zipFile) {
        ZipEntry entry;
        ArrayList<String> hlp = new ArrayList<String>();
        HashMap<String, ZipEntry> res = new HashMap<String, ZipEntry>();
        if (zipFile == null) {
            return res;
        }
        Enumeration<? extends ZipEntry> enu = zipFile.entries();
        while (enu.hasMoreElements()) {
            ZipEntry entry2 = enu.nextElement();
            res.put(entry2.getName(), entry2);
            hlp.add(entry2.getName());
        }
        HashSet<String> newEntryNames = new HashSet<String>();
        for (String name : hlp) {
            entry = (ZipEntry)res.get(name);
            List<String> allParentDirs = this.getAllParentDirNames(entry);
            for (String parentDirName : allParentDirs) {
                if (res.containsKey(parentDirName)) continue;
                newEntryNames.add(parentDirName);
            }
        }
        for (String name : newEntryNames) {
            entry = new ZipEntry(name);
            res.put(name, entry);
        }
        return res;
    }

    private List<String> getAllParentDirNames(ZipEntry entry) {
        String name = entry.getName();
        ArrayList<String> res = new ArrayList<String>();
        int last = name.lastIndexOf(SEPARATOR);
        while (last > 0) {
            res.add(name.substring(0, last + 1));
            name = name.substring(0, last);
            last = name.lastIndexOf(SEPARATOR);
        }
        return res;
    }

    public List<String> getFileNames(ZipFile aFile) {
        Map<String, ZipEntry> entries = this.readEntries(aFile);
        ArrayList<String> theResult = new ArrayList<String>();
        for (Map.Entry<String, ZipEntry> theEntry : entries.entrySet()) {
            if (theEntry.getValue().isDirectory()) continue;
            theResult.add(theEntry.getKey());
        }
        return theResult;
    }

    public SimpleResult buildTree(ZipFile aFile) {
        Map<String, ZipEntry> entries = this.readEntries(aFile);
        ArrayList<SimpleResult> allSRs = new ArrayList<SimpleResult>();
        Iterator<ZipEntry> iter = entries.values().iterator();
        HashMap<String, SimpleResult> srMap = new HashMap<String, SimpleResult>();
        while (iter.hasNext()) {
            ZipEntry theEntry = iter.next();
            SimpleResult theSR = new SimpleResult(theEntry, aFile);
            srMap.put(theSR.getName(), theSR);
            allSRs.add(theSR);
        }
        for (SimpleResult theSR : allSRs) {
            SimpleResult theParent = (SimpleResult)srMap.get(theSR.getPath());
            if (theParent == null) continue;
            theParent.addChild(theSR);
            theSR.setParent(theParent);
        }
        SimpleResult theRoot = new SimpleResult("Grundverzeichnis", aFile);
        for (SimpleResult theSR : allSRs) {
            if (!StringServices.isEmpty((CharSequence)theSR.getPath())) continue;
            theRoot.addChild(theSR);
            theSR.setParent(theRoot);
        }
        return theRoot;
    }

    /*
     * WARNING - void declaration
     */
    public EntryResult compare(ZipFile zip1, ZipFile zip2) {
        void var10_13;
        this.buildTree(zip1);
        Map<String, ZipEntry> entries1 = this.readEntries(zip1);
        Map<String, ZipEntry> entries2 = this.readEntries(zip2);
        List<EntryResult> compare = this.getCompareMap(entries1, entries2, zip1, zip2);
        HashMap<String, EntryResult> diretories = new HashMap<String, EntryResult>();
        for (EntryResult res : compare) {
            if (!res.isDirectory()) continue;
            diretories.put(res.getName(), res);
        }
        ZipEntry[] hlp = new ZipEntry[2];
        EntryResult root = new EntryResult("", hlp, null, null, this.listener);
        diretories.put("", root);
        for (EntryResult entryResult : compare) {
            String path = entryResult.getPath();
            EntryResult parent = (EntryResult)diretories.get(path);
            parent.addChild(entryResult);
            entryResult.setParent(parent);
        }
        root.setUpStateRecursively();
        root.initRootCompareStatistic();
        for (EntryResult theER : compare) {
            theER.initCompareStatistics();
        }
        compare.get(0).setPreviousEntryResult(root);
        if (compare.size() > 1) {
            compare.get(0).setNextEntryResult(compare.get(1));
        } else {
            compare.get(0).setNextEntryResult(compare.get(0));
        }
        boolean bl = true;
        while (var10_13 < compare.size() - 1) {
            compare.get((int)var10_13).setPreviousEntryResult(compare.get((int)(var10_13 - true)));
            compare.get((int)var10_13).setNextEntryResult(compare.get((int)(var10_13 + true)));
            ++var10_13;
        }
        if (compare.size() > 1) {
            compare.get(compare.size() - 1).setNextEntryResult(root);
            compare.get(compare.size() - 1).setPreviousEntryResult(compare.get(compare.size() - 2));
        } else {
            compare.get(compare.size() - 1).setNextEntryResult(root);
            compare.get(compare.size() - 1).setPreviousEntryResult(compare.get(compare.size() - 1));
        }
        root.setNextEntryResult(compare.get(0));
        root.setPreviousEntryResult(compare.get(compare.size() - 1));
        return root;
    }

    private List<EntryResult> getCompareMap(Map<String, ZipEntry> entries1, Map<String, ZipEntry> entries2, ZipFile zip1, ZipFile zip2) {
        EntryResult entRes;
        ZipEntry[] hlp;
        String s1;
        ArrayList<EntryResult> result = new ArrayList<EntryResult>();
        List<String> names1 = this.getSortedNames(entries1);
        List<String> names2 = this.getSortedNames(entries2);
        int l1 = names1.size();
        int l2 = names2.size();
        int p1 = 0;
        int p2 = 0;
        while (p1 < l1 && p2 < l2) {
            s1 = names1.get(p1);
            String s2 = names2.get(p2);
            ZipEntry[] hlp2 = new ZipEntry[2];
            String name = null;
            int compare = s1.compareTo(s2);
            if (compare == 0) {
                hlp2[0] = entries1.get(s1);
                hlp2[1] = entries2.get(s2);
                ++p1;
                ++p2;
                name = s1;
            } else if (compare < 0) {
                hlp2[0] = entries1.get(s1);
                hlp2[1] = null;
                ++p1;
                name = s1;
            } else if (compare > 0) {
                hlp2[0] = null;
                hlp2[1] = entries2.get(s2);
                ++p2;
                name = s2;
            }
            EntryResult entRes2 = new EntryResult(name, hlp2, zip1, zip2, this.listener);
            result.add(entRes2);
        }
        while (p1 < l1) {
            s1 = names1.get(p1);
            hlp = new ZipEntry[]{entries1.get(s1), null};
            entRes = new EntryResult(s1, hlp, zip1, zip2, this.listener);
            result.add(entRes);
            ++p1;
        }
        while (p2 < l2) {
            String s2 = names2.get(p2);
            hlp = new ZipEntry[]{null, entries2.get(s2)};
            entRes = new EntryResult(s2, hlp, zip1, zip2, this.listener);
            result.add(entRes);
            ++p2;
        }
        return result;
    }

    private List<String> getSortedNames(Map<String, ZipEntry> aMap) {
        ArrayList<String> names = new ArrayList<String>(aMap.keySet());
        Collections.sort(names);
        return names;
    }

    public EntryResult compare(Document aFirstVersion, Document aSecondVersion) {
        ZipFile zipFile1 = this.getZipFromDocument(aFirstVersion);
        ZipFile zipFile2 = this.getZipFromDocument(aSecondVersion);
        return this.compare(zipFile1, zipFile2);
    }

    private ZipFile getZipFromDocument(Document aDoc) {
        if (aDoc == null) {
            return null;
        }
        File theTempFile = this.getTempFileFromDocument(aDoc);
        try {
            ZipFile theZipFile = new ZipFile(theTempFile);
            return theZipFile;
        }
        catch (Exception ex) {
            throw new RuntimeException("Problems creating a ZipFile from File", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private File getTempFileFromDocument(Document aDoc) {
        try {
            File theFile = File.createTempFile("compareZip", "tempe", Settings.getInstance().getTempDir());
            try (FileOutputStream theOS = new FileOutputStream(theFile);){
                File file;
                InputStream theIS = aDoc.getStream();
                try {
                    int length;
                    byte[] buf = new byte[1024];
                    while ((length = theIS.read(buf)) > 0) {
                        ((OutputStream)theOS).write(buf, 0, length);
                    }
                    file = theFile;
                }
                catch (Throwable throwable) {
                    theIS.close();
                    throw throwable;
                }
                theIS.close();
                return file;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Problems creating a TempFile", ex);
        }
    }

    private static String readFromStream(InputStream is, String aDefaultEncoding) throws IOException {
        BOMAwareReader bar = new BOMAwareReader(is, aDefaultEncoding);
        BufferedReader reader = new BufferedReader((Reader)bar);
        StringBuffer buffer = new StringBuffer();
        int c = reader.read();
        while (c > -1) {
            buffer.append((char)c);
            c = reader.read();
        }
        reader.close();
        bar.close();
        return buffer.toString();
    }

    public static class SimpleResult {
        private final String name;
        private SimpleResult parent;
        private List<SimpleResult> children;

        public SimpleResult(String aName, ZipFile zip) {
            this.name = aName;
            this.children = new ArrayList<SimpleResult>();
        }

        public SimpleResult(ZipEntry zipEntry, ZipFile zip) {
            this.name = zipEntry.getName();
            this.children = new ArrayList<SimpleResult>();
        }

        public void setParent(SimpleResult aParent) {
            this.parent = aParent;
        }

        public List<SimpleResult> getChildren() {
            return this.children;
        }

        public void addChild(SimpleResult entry) {
            this.children.add(entry);
        }

        public String getPath() {
            String hlp = null;
            hlp = this.isDirectory() ? this.name.substring(0, this.name.length() - 1) : this.name;
            int i = hlp.lastIndexOf(ZipReader.SEPARATOR);
            if (i < 0) {
                return "";
            }
            return hlp.substring(0, i + 1);
        }

        public boolean isDirectory() {
            return this.name.endsWith(ZipReader.SEPARATOR) || this.parent == null;
        }

        public String getName() {
            return this.name;
        }

        public String getPlainName() {
            if (this.parent != null) {
                return this.name.substring(this.parent.getName().length());
            }
            return this.name;
        }

        public SimpleResult getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getPath() + ", " + this.getPlainName();
        }
    }

    public static class EntryResult {
        private final String name;
        private final ZipEntry[] zipEntries;
        private final ZipFile zip0;
        private final ZipFile zip1;
        private State state;
        private List<EntryResult> children = new ArrayList<EntryResult>();
        private EntryResult parent;
        private EntryResult previousEntryResult;
        private EntryResult nextEntryResult;
        private CompareStatistics statistics = null;
        private final RootCompareStatistic.CompareExecutedListener listener;

        public EntryResult(String name, ZipEntry[] zipEntries, ZipFile zip0, ZipFile zip1, RootCompareStatistic.CompareExecutedListener aCLE) {
            this.name = name;
            this.zipEntries = zipEntries;
            this.zip0 = zip0;
            this.zip1 = zip1;
            this.listener = aCLE;
            this.computeState();
        }

        public String setUpStateRecursively() {
            this.internalSetUpStateRecursively();
            return this.getStateAsString();
        }

        private void internalSetUpStateRecursively() {
            boolean changedChild = false;
            for (EntryResult res : this.getChildren()) {
                res.internalSetUpStateRecursively();
                State childState = res.getState();
                if (State.NO_CHANGE == childState) continue;
                changedChild = true;
            }
            if (this.isDirectory()) {
                if (changedChild) {
                    boolean first = true;
                    for (EntryResult res : this.getChildren()) {
                        if (first) {
                            first = false;
                            this.state = res.getState();
                            continue;
                        }
                        if (this.state == res.getState()) continue;
                        this.state = State.CHANGE;
                    }
                } else {
                    this.state = State.NO_CHANGE;
                }
            }
        }

        public void initCompareStatistics() {
            this.statistics = new CompareStatistics(this);
        }

        public void initRootCompareStatistic() {
            RootCompareStatistic theRootCS = new RootCompareStatistic(this);
            theRootCS.setCompareExecutedListener(this.listener);
            this.statistics = theRootCS;
        }

        public String getSourceName() {
            return this.zip0.getName();
        }

        public String getDestName() {
            return this.zip1.getName();
        }

        public String getSource() {
            return this.getAsString(this.zipEntries[0], this.zip0);
        }

        public String getDest() {
            return this.getAsString(this.zipEntries[1], this.zip1);
        }

        private String getAsString(ZipEntry zipEntry, ZipFile zipFile) {
            if (zipEntry == null) {
                return "";
            }
            try {
                InputStream stream = zipFile.getInputStream(zipEntry);
                return ZipReader.readFromStream(stream, ENCODING);
            }
            catch (IOException e) {
                Logger.error((String)("Problem reading data for ZipEntry " + zipEntry.getName()), (Throwable)e, (Object)this);
                return "Data could not be read";
            }
        }

        public void setParent(EntryResult aParent) {
            this.parent = aParent;
        }

        public EntryResult getParent() {
            return this.parent;
        }

        public List<EntryResult> getChildren() {
            return this.children;
        }

        public void addChild(EntryResult entry) {
            this.children.add(entry);
        }

        public String getPath() {
            String hlp = null;
            hlp = this.isDirectory() ? this.name.substring(0, this.name.length() - 1) : this.name;
            int i = hlp.lastIndexOf(ZipReader.SEPARATOR);
            if (i < 0) {
                return "";
            }
            return hlp.substring(0, i + 1);
        }

        public boolean isDirectory() {
            return this.name.endsWith(ZipReader.SEPARATOR) || this.parent == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeState() {
            block11: {
                if (this.zipEntries[0] == null) {
                    this.state = this.zipEntries[1] == null ? State.NO_CHANGE : State.NEW;
                    return;
                }
                if (this.zipEntries[1] == null) {
                    this.state = State.DELETED;
                    return;
                }
                try {
                    boolean isEqual;
                    if (this.zipEntries[0].isDirectory()) {
                        this.state = State.NO_CHANGE;
                        break block11;
                    }
                    try (InputStream stream0 = this.zip0.getInputStream(this.zipEntries[0]);
                         InputStream stream1 = this.zip1.getInputStream(this.zipEntries[1]);){
                        isEqual = StreamUtilities.equalsStreamContents((InputStream)stream0, (InputStream)stream1);
                    }
                    this.state = isEqual ? State.NO_CHANGE : State.CHANGE;
                }
                catch (IOException e) {
                    String text = "Problem comparing zipEntries files " + String.valueOf(this.zipEntries[0]) + " and " + String.valueOf(this.zipEntries[1]);
                    Logger.warn((String)text, (Throwable)e, (Object)this);
                    throw new RuntimeException(text);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getPlainName() {
            if (this.parent != null) {
                return this.name.substring(this.parent.getName().length());
            }
            return this.name;
        }

        public State getState() {
            return this.state;
        }

        public String getStateAsString() {
            return this.getState().getExternalName();
        }

        public ZipEntry getSourceEntry() {
            return this.zipEntries[0];
        }

        public ZipEntry getDestEntry() {
            return this.zipEntries[1];
        }

        public CompareStatistics getStatistics() {
            return this.statistics;
        }

        public EntryResult getPreviousEntryResult() {
            return this.previousEntryResult;
        }

        public void setPreviousEntryResult(EntryResult previousEntryResult) {
            this.previousEntryResult = previousEntryResult;
        }

        public EntryResult getNextEntryResult() {
            return this.nextEntryResult;
        }

        public void setNextEntryResult(EntryResult nextEntryResult) {
            this.nextEntryResult = nextEntryResult;
        }

        public static enum State implements ExternallyNamed
        {
            NEW("new"),
            DELETED("deleted"),
            NO_CHANGE("noChange"),
            CHANGE("change");

            private final String _externalName;

            private State(String externalName) {
                this._externalName = externalName;
            }

            public String getExternalName() {
                return this._externalName;
            }

            public String toString() {
                return this.getExternalName();
            }
        }
    }
}

