/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template;

import com.top_logic.basic.StringServices;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.annotation.defaults.StringDefault;
import com.top_logic.basic.module.ConfiguredManagedClass;
import com.top_logic.basic.module.ServiceDependencies;
import com.top_logic.basic.module.TypedRuntimeModule;
import com.top_logic.template.xml.source.TemplateSourceFactory;

@ServiceDependencies(value={TemplateSourceFactory.Module.class})
public class ScriptTemplateFinder
extends ConfiguredManagedClass<ScriptTemplateFinderConfig> {
    public ScriptTemplateFinder(InstantiationContext context, ScriptTemplateFinderConfig config) {
        super(context, (ConfiguredManagedClass.Config)config);
    }

    public static ScriptTemplateFinder getInstance() {
        return (ScriptTemplateFinder)Module.INSTANCE.getImplementationInstance();
    }

    public String findScriptResourceFor(String businessObject, String businessAction) {
        String fileName = this.buildFileName(businessObject, businessAction);
        String scriptPrefix = this.getScriptResourcePrefix(businessObject, businessAction);
        String resourceName = scriptPrefix + "/" + fileName;
        return resourceName;
    }

    protected String buildFileName(String businessObject, String businessAction) {
        if (StringServices.isEmpty((CharSequence)businessAction) && StringServices.isEmpty((CharSequence)businessObject)) {
            return "Action.xml";
        }
        if (StringServices.isEmpty((CharSequence)businessAction)) {
            return "Action-" + businessObject + ".xml";
        }
        if (StringServices.isEmpty((CharSequence)businessObject)) {
            return "Action-" + businessAction + ".xml";
        }
        return "Action-" + businessObject + "-" + businessAction + ".xml";
    }

    protected String getScriptResourcePrefix(String businessObject, String businessAction) {
        String dirName = businessObject;
        if (StringServices.isEmpty((CharSequence)dirName)) {
            dirName = this.getMiscPath();
        }
        return "script:/" + dirName;
    }

    private String getMiscPath() {
        return ((ScriptTemplateFinderConfig)this.getConfig()).getMiscPath();
    }

    public static final class Module
    extends TypedRuntimeModule<ScriptTemplateFinder> {
        public static final Module INSTANCE = new Module();

        private Module() {
        }

        public Class<ScriptTemplateFinder> getImplementation() {
            return ScriptTemplateFinder.class;
        }
    }

    public static interface ScriptTemplateFinderConfig
    extends ConfiguredManagedClass.Config<ScriptTemplateFinder> {
        public static final String DEFAULT_MISC_PATH = "misc";

        @StringDefault(value="misc")
        public String getMiscPath();
    }
}

