/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template;

import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.recorder.ActionWriter;
import com.top_logic.layout.scripting.runtime.ActionReader;
import com.top_logic.template.expander.TemplateExpander;
import com.top_logic.template.xml.source.TemplateSource;
import com.top_logic.template.xml.source.TemplateSourceFactory;
import java.io.File;
import java.util.Map;

public class ScriptUtil {
    public static final ScriptUtil DEFAULT = new ScriptUtil();

    protected ScriptUtil() {
    }

    public String actionToXml(ApplicationAction action) {
        return ActionWriter.INSTANCE.writeAction(action);
    }

    public ApplicationAction parseAction(String actionXml) {
        try {
            return ActionReader.INSTANCE.readAction(actionXml);
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ApplicationAction readAction(File file) {
        return ActionReader.INSTANCE.readAction(file);
    }

    public ApplicationAction createActionFromTemplate(String templateResource, Map<String, ?> templateParameters) {
        try {
            return this.parseScript(this.expandTemplate(templateResource, templateParameters));
        }
        catch (Exception ex) {
            throw new RuntimeException("Creating the actions failed for '" + templateResource + "'; Message: " + ex.getMessage(), ex);
        }
    }

    public String expandTemplate(String templateResource, Map<String, ?> templateParameters) {
        TemplateSource source = TemplateSourceFactory.getInstance().resolve(templateResource);
        String result = null;
        try {
            result = TemplateExpander.expandXmlTemplate((TemplateSource)source, templateParameters);
        }
        catch (Throwable e) {
            throw new RuntimeException("Expanding the template failed! File: '" + templateResource + "', Cause: " + e.getMessage(), e);
        }
        if (result == null) {
            throw new NullPointerException("TemplateExpander returned null for file: " + templateResource);
        }
        return result;
    }

    protected ApplicationAction parseScript(String script) {
        try {
            ApplicationAction action = ActionReader.INSTANCE.readAction(script);
            if (action == null) {
                throw new RuntimeException("Parsing the test script failed!");
            }
            return action;
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException("Parsing the test script failed! Message: " + ex.getMessage(), ex);
        }
    }
}

