/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.check;

import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.knowledge.wrap.Wrapper;
import com.top_logic.layout.scripting.check.ValueCheck;
import com.top_logic.layout.scripting.runtime.ActionContext;
import com.top_logic.layout.scripting.runtime.action.ApplicationAssertion;
import com.top_logic.layout.scripting.runtime.action.ApplicationAssertions;
import com.top_logic.layout.scripting.template.fuzzy.FuzzyUtil;
import java.text.ParseException;

public class AttributeValueCheck
extends ValueCheck<AttributeValueCheckConfig> {
    public AttributeValueCheck(InstantiationContext context, AttributeValueCheckConfig config) {
        super(context, (ValueCheck.ValueCheckConfig)config);
    }

    public void check(ActionContext context, Object value) throws ApplicationAssertion {
        Object fuzzyValue;
        String attributeName = ((AttributeValueCheckConfig)this._config).getAttribute();
        String expected = ((AttributeValueCheckConfig)this._config).getValue();
        ApplicationAssertions.assertNotNull((ConfigurationItem)this._config, (String)("Value is null, no chance to get attribute " + attributeName), (Object)value);
        ApplicationAssertions.assertInstanceOf((ConfigurationItem)this._config, (String)"", Wrapper.class, (Object)value);
        Object actual = ((Wrapper)value).getValue(attributeName);
        if (actual == null) {
            if (expected.isEmpty() && ((AttributeValueCheckConfig)this._config).getNull()) {
                return;
            }
            throw ApplicationAssertions.fail((ConfigurationItem)this._config, (String)("Expected '" + expected + "' but was null"));
        }
        try {
            fuzzyValue = FuzzyUtil.parseFuzzy(actual.getClass(), expected);
        }
        catch (ParseException ex) {
            throw ApplicationAssertions.fail((ConfigurationItem)this._config, (String)("Unable to create application value for '" + expected + "'"), (Throwable)ex);
        }
        ApplicationAssertions.assertEquals((ConfigurationItem)this._config, (String)"", fuzzyValue, (Object)actual);
    }

    public static interface AttributeValueCheckConfig
    extends ValueCheck.ValueCheckConfig {
        public String getAttribute();

        public String getValue();

        public boolean getNull();
    }
}

