/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.check;

import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.annotation.Mandatory;
import com.top_logic.basic.config.annotation.defaults.ClassDefault;
import com.top_logic.layout.component.TabComponent;
import com.top_logic.layout.scripting.action.ComponentAction;
import com.top_logic.layout.scripting.runtime.ActionContext;
import com.top_logic.layout.scripting.runtime.action.ApplicationAssertions;
import com.top_logic.layout.scripting.runtime.action.CheckVisibilityOp;
import com.top_logic.layout.scripting.runtime.action.ComponentActionOp;
import com.top_logic.layout.tabbar.TabBarModel;
import com.top_logic.mig.html.layout.Card;
import com.top_logic.mig.html.layout.LayoutComponent;
import java.util.stream.Collectors;

public class TabSelectableCheck
extends ComponentActionOp<TabSelectableCheckConfig> {
    public TabSelectableCheck(InstantiationContext context, TabSelectableCheckConfig config) {
        super(context, (ComponentAction)config);
    }

    protected Object process(ActionContext context, LayoutComponent component, Object argument) {
        boolean isActive;
        TabComponent tab = (TabComponent)component;
        TabBarModel tabModel = tab.getTabBarModel();
        boolean bl = isActive = !tabModel.isInactive(this.getCard(tabModel, ((TabSelectableCheckConfig)this.getConfig()).getCardName()));
        if (isActive != ((TabSelectableCheckConfig)this.getConfig()).isSelectable()) {
            StringBuilder failure = new StringBuilder();
            failure.append("Tab ");
            failure.append(component);
            failure.append(" is ");
            failure.append(isActive ? "active" : "inactive");
            failure.append(" but is asserted that not.");
            throw ApplicationAssertions.fail((ConfigurationItem)this.getConfig(), (String)failure.toString());
        }
        return argument;
    }

    private Card getCard(TabBarModel tabModel, String cardName) {
        for (Card card : tabModel.getAllCards()) {
            if (!cardName.equals(card.getName())) continue;
            return card;
        }
        throw ApplicationAssertions.fail((ConfigurationItem)this.getConfig(), (String)("No card with name " + cardName + ". Available: " + tabModel.getAllCards().stream().map(Card::getName).collect(Collectors.joining(", "))));
    }

    public static interface TabSelectableCheckConfig
    extends ComponentAction {
        @ClassDefault(value=TabSelectableCheck.class)
        public Class<CheckVisibilityOp> getImplementationClass();

        @Mandatory
        public String getCardName();

        public void setCardName(String var1);

        public boolean isSelectable();

        public void setSelectable(boolean var1);
    }
}

