/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.excel;

import com.top_logic.basic.StringServices;
import com.top_logic.basic.config.ApplicationConfig;
import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.NamedConfiguration;
import com.top_logic.basic.config.annotation.EntryTag;
import com.top_logic.basic.config.annotation.Key;
import com.top_logic.layout.scripting.template.excel.ExcelActionOp;
import java.util.Map;

public class ExcelActionRegistry {
    public static Config getExcelActionRegistry() {
        return (Config)ApplicationConfig.getInstance().getConfig(Config.class);
    }

    public static Class<? extends ExcelActionOp<?>> getExcelActionOpClass(Config registry, String businessAction, String businessObject) {
        ExcelBusinessObject actionsForObject = registry.getRegistrations().get(StringServices.nonNull((String)businessObject));
        if (actionsForObject == null) {
            return null;
        }
        ExcelBusinessAction actionRegistration = actionsForObject.getActions().get(StringServices.nonNull((String)businessAction));
        if (actionRegistration == null) {
            return null;
        }
        return actionRegistration.getImplementation();
    }

    public static interface ExcelBusinessAction
    extends NamedConfiguration {
        public String getName();

        public Class<? extends ExcelActionOp<?>> getImplementation();
    }

    public static interface ExcelBusinessObject
    extends NamedConfiguration {
        public String getName();

        @Key(value="name")
        public Map<String, ExcelBusinessAction> getActions();
    }

    public static interface Config
    extends ConfigurationItem {
        @Key(value="name")
        @EntryTag(value="object-type")
        public Map<String, ExcelBusinessObject> getRegistrations();
    }
}

