/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.excel;

import com.top_logic.base.office.POIUtil;
import com.top_logic.basic.CollectionUtil;
import com.top_logic.basic.StringServices;
import com.top_logic.basic.UnreachableAssertion;
import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.TypedConfiguration;
import com.top_logic.basic.config.annotation.Name;
import com.top_logic.basic.io.binary.BinaryData;
import com.top_logic.basic.util.ResKey;
import com.top_logic.basic.util.ResourceTransaction;
import com.top_logic.basic.util.ResourcesModule;
import com.top_logic.layout.scripting.action.ActionChain;
import com.top_logic.layout.scripting.action.ActionFactory;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.recorder.ref.ModelName;
import com.top_logic.layout.scripting.recorder.ref.value.StringValue;
import com.top_logic.layout.scripting.template.action.BusinessOperationTemplateAction;
import com.top_logic.layout.scripting.template.action.TemplateAction;
import com.top_logic.layout.scripting.template.excel.ExcelActionRegistry;
import com.top_logic.layout.scripting.template.excel.ExcelCollector;
import com.top_logic.layout.scripting.template.excel.ExcelRow;
import com.top_logic.layout.scripting.util.LazyActionProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelChecker
extends LazyActionProvider {
    private static final String MICROSOFTS_TEMP_FILE_PREFIX = "~$";
    public static final int DEFAULT_START_ROW = 1;
    private static final int START_COLUMN = 0;
    private static final String[] COLUMN_HEADERS = new String[]{"ergebnis", "aktion", "fachobjekt", "kontext", "parameter"};
    private final String _name;
    private final BinaryData _excelLocation;
    private final ExcelCollector.ExcelFileConfig.BasicSheetSet _basicSheetSet;
    private final List<ExcelCollector.ExcelSheetConfig> _sheetConfigs;
    private final int _startRow;

    public ExcelChecker(String name, BinaryData excelLocation, String ... sheetNames) {
        this(name, excelLocation, 1, sheetNames);
    }

    public ExcelChecker(String name, BinaryData excelLocation, int startRow, String ... sheetNames) {
        this(name, excelLocation, startRow, ExcelCollector.ExcelFileConfig.BasicSheetSet.NONE, ExcelChecker.buildSheetsConfig(sheetNames));
    }

    public ExcelChecker(String name, BinaryData excelLocation, ExcelCollector.ExcelFileConfig.BasicSheetSet basicSheetSet, List<ExcelCollector.ExcelSheetConfig> sheetConfigs) {
        this(name, excelLocation, 1, basicSheetSet, sheetConfigs);
    }

    public ExcelChecker(String name, BinaryData excelLocation, int startRow, ExcelCollector.ExcelFileConfig.BasicSheetSet basicSheetSet, List<ExcelCollector.ExcelSheetConfig> sheetConfigs) {
        if (StringServices.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("The name is required and must not be null or empty.");
        }
        if (excelLocation == null) {
            throw new NullPointerException("No excel file location given.");
        }
        if (basicSheetSet == null) {
            throw new NullPointerException("basicSheetSet must not be null.");
        }
        this._name = name;
        this._excelLocation = excelLocation;
        this._startRow = startRow;
        this._basicSheetSet = basicSheetSet;
        this._sheetConfigs = CollectionUtil.nonNull(sheetConfigs);
    }

    public String getName() {
        return this._name;
    }

    private static List<ExcelCollector.ExcelSheetConfig> buildSheetsConfig(String[] sheetNames) {
        ArrayList<ExcelCollector.ExcelSheetConfig> sheetConfigs = new ArrayList<ExcelCollector.ExcelSheetConfig>();
        for (String sheetName : sheetNames) {
            ExcelCollector.ExcelSheetConfig sheetConfig = (ExcelCollector.ExcelSheetConfig)TypedConfiguration.newConfigItem(ExcelCollector.ExcelSheetConfig.class);
            sheetConfig.setName(sheetName);
            sheetConfig.setSheetOperator(ExcelCollector.ExcelSheetConfig.SheetOperator.ADD);
            sheetConfigs.add(sheetConfig);
        }
        return sheetConfigs;
    }

    protected ApplicationAction createAction() {
        try {
            return this.parse();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create ApplicationActions for excel '" + this._excelLocation + "', basic sheet set: " + this._basicSheetSet + ", sheet configurations: '" + this._sheetConfigs + "': " + ex.getMessage(), ex);
        }
    }

    private ActionChain parse() throws Exception {
        ArrayList<ApplicationAction> theActions = new ArrayList<ApplicationAction>();
        Workbook workbook = ExcelChecker.getWorkbook(this._excelLocation);
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        List<Sheet> sheets = this.getRequestedSheets(workbook, evaluator);
        for (Sheet sheet : sheets) {
            theActions.add(this.processSheet(sheet, evaluator, this._startRow));
        }
        ActionChain theChain = ActionFactory.actionChain(theActions);
        String name = this._excelLocation.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        theChain.setComment(name);
        return theChain;
    }

    private List<Sheet> getRequestedSheets(Workbook workbook, FormulaEvaluator evaluator) {
        Map<String, ExcelCollector.ExcelSheetConfig> unappliedSheetConfigs = this.buildSheetMap();
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            String sheetName;
            Sheet sheet = workbook.getSheetAt(i);
            if (this.isRequested(sheet, unappliedSheetConfigs.get(sheetName = sheet.getSheetName()), evaluator)) {
                sheets.add(sheet);
            }
            unappliedSheetConfigs.remove(sheetName);
        }
        this.checkForUnknownRequestedSheets(unappliedSheetConfigs);
        return sheets;
    }

    private void checkForUnknownRequestedSheets(Map<String, ExcelCollector.ExcelSheetConfig> sheetMap) {
        this.removeUnrequestedSheets(sheetMap);
        if (!sheetMap.isEmpty()) {
            throw new IllegalArgumentException("Sheets not found in excel file, but potentially requested: " + sheetMap);
        }
    }

    private void removeUnrequestedSheets(Map<String, ExcelCollector.ExcelSheetConfig> sheetMap) {
        Iterator<ExcelCollector.ExcelSheetConfig> iterator = sheetMap.values().iterator();
        while (iterator.hasNext()) {
            ExcelCollector.ExcelSheetConfig sheetEntry = iterator.next();
            if (sheetEntry.getSheetOperator() != ExcelCollector.ExcelSheetConfig.SheetOperator.REMOVE) continue;
            iterator.remove();
        }
    }

    private Map<String, ExcelCollector.ExcelSheetConfig> buildSheetMap() {
        HashMap<String, ExcelCollector.ExcelSheetConfig> sheets = new HashMap<String, ExcelCollector.ExcelSheetConfig>();
        for (ExcelCollector.ExcelSheetConfig sheetConfig : this._sheetConfigs) {
            sheets.put(sheetConfig.getName(), sheetConfig);
        }
        return sheets;
    }

    private boolean isRequested(Sheet sheet, ExcelCollector.ExcelSheetConfig sheetConfig, FormulaEvaluator evaluator) {
        switch (this._basicSheetSet) {
            case NONE: {
                if (sheetConfig == null || sheetConfig.getSheetOperator() == ExcelCollector.ExcelSheetConfig.SheetOperator.REMOVE) {
                    return false;
                }
                if (sheetConfig.getSheetOperator() == ExcelCollector.ExcelSheetConfig.SheetOperator.ADD) {
                    return true;
                }
                return this.isActive(sheet, evaluator);
            }
            case ALL: {
                if (sheetConfig == null || sheetConfig.getSheetOperator() == ExcelCollector.ExcelSheetConfig.SheetOperator.ADD) {
                    return true;
                }
                if (sheetConfig.getSheetOperator() == ExcelCollector.ExcelSheetConfig.SheetOperator.REMOVE) {
                    return false;
                }
                return this.isActive(sheet, evaluator);
            }
            case FILE_DEFINED: {
                if (sheetConfig == null || sheetConfig.getSheetOperator() == ExcelCollector.ExcelSheetConfig.SheetOperator.SHEET_DEFINED) {
                    return this.isActive(sheet, evaluator);
                }
                return sheetConfig.getSheetOperator() == ExcelCollector.ExcelSheetConfig.SheetOperator.ADD;
            }
        }
        throw new UnreachableAssertion("Unknown " + ExcelCollector.ExcelFileConfig.BasicSheetSet.class + " instance '" + StringServices.getObjectDescription((Object)((Object)this._basicSheetSet)) + "'.");
    }

    public boolean isActive(Sheet sheet, FormulaEvaluator evaluator) {
        int columnHeaderRow = this._startRow - 1;
        Row row = sheet.getRow(columnHeaderRow);
        if (row == null) {
            return false;
        }
        for (int i = 0; i < COLUMN_HEADERS.length + 0; ++i) {
            Cell columnHeaderCell = row.getCell(i);
            if (columnHeaderCell == null) {
                return false;
            }
            CellValue columnHeaderValue = evaluator.evaluate(columnHeaderCell);
            if (columnHeaderValue.getCellType() != CellType.STRING) {
                return false;
            }
            String columnHeaderText = columnHeaderValue.getStringValue();
            if (columnHeaderText.isEmpty()) {
                return false;
            }
            if (columnHeaderText.toLowerCase().startsWith(COLUMN_HEADERS[i])) continue;
            return false;
        }
        return true;
    }

    private ApplicationAction processSheet(Sheet sheet, FormulaEvaluator evaluator, int ignoreRows) throws Exception {
        ApplicationAction action;
        ExcelActionRegistry.Config excelActionRegistry = ExcelActionRegistry.getExcelActionRegistry();
        ArrayList<Object> actions = new ArrayList<Object>();
        for (ExcelRow row : this.getSheetRows(sheet, evaluator)) {
            if (ignoreRows > 0) {
                --ignoreRows;
                continue;
            }
            action = this.prepareRow(row, excelActionRegistry);
            actions.add(action);
        }
        int end = actions.size();
        for (int n = end - 1; n >= 0; --n) {
            ModelName text;
            action = (ApplicationAction)actions.get(n);
            if (!this.isComment(action)) continue;
            Optional<TemplateAction.Parameter> textParam = ((BusinessOperationTemplateAction)action).getParameters().stream().filter(p -> "text".equals(p.getName())).findFirst();
            ActionChain group = ActionFactory.actionChain(actions.subList(n, end));
            if (textParam.isPresent() && (text = textParam.get().getValue()) instanceof StringValue) {
                group.setComment(((StringValue)text).getString());
            }
            actions.set(n, group);
            for (int m = end - 1; m > n; --m) {
                actions.remove(m);
            }
            end = n;
        }
        ActionChain result = ActionFactory.actionChain(actions);
        result.setComment(sheet.getSheetName());
        return result;
    }

    private boolean isComment(ApplicationAction action) {
        if (action instanceof BusinessOperationTemplateAction) {
            return "Kommentar".equals(((BusinessOperationTemplateAction)action).getBusinessAction());
        }
        return false;
    }

    private ApplicationAction prepareRow(ExcelRow aRow, ExcelActionRegistry.Config excelActionRegistry) throws ConfigurationException {
        return aRow.getAction(excelActionRegistry);
    }

    private static void saveI18N(ResKey key, String aDE, String anEN) {
        try (ResourceTransaction tx = ResourcesModule.getInstance().startResourceTransaction();){
            tx.saveI18N(Locale.GERMAN, key, aDE);
            tx.saveI18N(Locale.ENGLISH, key, anEN);
            tx.commit();
        }
    }

    public static void saveI18N(ResKey key, I18NConfig someI18N) {
        ExcelChecker.saveI18N(key, someI18N.getDE(), someI18N.getEN());
    }

    private static Workbook getWorkbook(BinaryData excelFile) {
        Workbook workbook;
        InputStream theStream = excelFile.getStream();
        if (theStream == null) {
            throw new IllegalArgumentException("File '" + excelFile + "' cannot be found!");
        }
        try {
            workbook = ExcelChecker.getWorkbook(excelFile.getName(), theStream);
        }
        catch (Throwable throwable) {
            try {
                theStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to access excel file '" + excelFile + "'. Reason: " + ex.getMessage(), ex);
            }
        }
        theStream.close();
        return workbook;
    }

    private static Workbook getWorkbook(String anExcelName, InputStream aStream) throws IOException {
        return POIUtil.newWorkbook((String)anExcelName, (InputStream)aStream);
    }

    private List<ExcelRow> getSheetRows(Sheet aSheet, FormulaEvaluator evaluator) {
        ArrayList<ExcelRow> theRows = new ArrayList<ExcelRow>();
        String theName = aSheet.getSheetName();
        Iterator theRowIterator = aSheet.rowIterator();
        while (theRowIterator.hasNext()) {
            ArrayList<Object> theValues = new ArrayList<Object>();
            Row theRow = (Row)theRowIterator.next();
            short theSize = theRow.getLastCellNum();
            for (short thePos = 0; thePos < theSize; thePos = (short)(thePos + 1)) {
                theValues.add(this.getCellValue(theRow, thePos, evaluator));
            }
            String filePath = this._excelLocation.getName();
            ExcelRow theTestRow = new ExcelRow(filePath, theName, theRow, theValues);
            if (!theTestRow.hasAction()) continue;
            theRows.add(theTestRow);
        }
        return theRows;
    }

    private <T> T getCellValue(Row aRow, int aActionColumn, FormulaEvaluator evaluator) {
        Cell theCell = aRow.getCell(aActionColumn);
        if (theCell != null) {
            Object theValue;
            switch (theCell.getCellType()) {
                case NUMERIC: {
                    theValue = theCell.getNumericCellValue();
                    break;
                }
                case BOOLEAN: {
                    theValue = theCell.getBooleanCellValue();
                    break;
                }
                case STRING: {
                    theValue = theCell.getStringCellValue();
                    break;
                }
                case FORMULA: {
                    theValue = this.evaluate(theCell, evaluator);
                    break;
                }
                default: {
                    theValue = null;
                }
            }
            return (T)theValue;
        }
        return null;
    }

    private Object evaluate(Cell aCell, FormulaEvaluator evaluator) {
        CellValue cellValue = evaluator.evaluate(aCell);
        switch (cellValue.getCellType()) {
            case BOOLEAN: {
                return cellValue.getBooleanValue();
            }
            case NUMERIC: {
                return cellValue.getNumberValue();
            }
            case STRING: {
                return cellValue.getStringValue();
            }
        }
        return null;
    }

    public static boolean supportsFile(File file) {
        return ExcelChecker.supportsFile(file.getName().toLowerCase());
    }

    public static boolean supportsFile(BinaryData file) {
        return ExcelChecker.supportsFile(file.getName().toLowerCase());
    }

    public static boolean supportsFile(String fileName) {
        if (fileName.startsWith(MICROSOFTS_TEMP_FILE_PREFIX)) {
            return false;
        }
        return fileName.endsWith(".xls") || fileName.endsWith(".xlsx");
    }

    public static interface I18NConfig
    extends ConfigurationItem {
        @Name(value="de")
        public String getDE();

        @Name(value="en")
        public String getEN();
    }
}

