/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.excel;

import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.NamedConfiguration;
import com.top_logic.basic.io.FileUtilities;
import com.top_logic.basic.io.binary.BinaryData;
import com.top_logic.basic.io.binary.BinaryDataFactory;
import com.top_logic.layout.scripting.template.excel.ExcelChecker;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelCollector {
    private final File _baseDir;
    private final ExcelCollectionConfig _config;

    public ExcelCollector(File baseDir, ExcelCollectionConfig config) {
        if (baseDir == null) {
            throw new NullPointerException();
        }
        if (config == null) {
            throw new NullPointerException();
        }
        this._baseDir = baseDir;
        this._config = config;
    }

    public List<ExcelChecker> collect() {
        if (this._config.getBasicFileSet() == ExcelCollectionConfig.BasicFileSet.ALL) {
            return this.collectAll(this._baseDir);
        }
        return this.collectSelective();
    }

    private List<ExcelChecker> collectAll(File baseDir) {
        File[] contents;
        Map<File, ExcelFileConfig> preconfiguredFiles = this.resolveFiles();
        ArrayList<ExcelChecker> result = new ArrayList<ExcelChecker>();
        try {
            contents = FileUtilities.listFiles((File)baseDir);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        for (File file : this.sort(contents)) {
            if (file.isDirectory()) {
                result.addAll(this.collectAll(file));
                continue;
            }
            ExcelFileConfig fileConfig = preconfiguredFiles.get(file);
            if (fileConfig != null && this.isDeactivated(fileConfig)) {
                preconfiguredFiles.remove(file);
                continue;
            }
            if (ExcelChecker.supportsFile(file)) {
                BinaryData fileLocation = BinaryDataFactory.createBinaryData((File)file);
                if (fileConfig == null) {
                    List<ExcelSheetConfig> sheetConfigs = Collections.emptyList();
                    result.add(new ExcelChecker(file.getName(), fileLocation, ExcelFileConfig.BasicSheetSet.FILE_DEFINED, sheetConfigs));
                    preconfiguredFiles.remove(file);
                    continue;
                }
                ExcelFileConfig.BasicSheetSet basicSheetSet = fileConfig.getBasicSheetSet();
                List<ExcelSheetConfig> sheetConfigs = fileConfig.getSheetConfigs();
                result.add(new ExcelChecker(file.getPath(), fileLocation, basicSheetSet, sheetConfigs));
                preconfiguredFiles.remove(file);
                continue;
            }
            if (fileConfig == null) continue;
            throw new IllegalArgumentException("File '" + file + "' is not supported but is part of the excel file list: " + fileConfig);
        }
        if (!preconfiguredFiles.isEmpty()) {
            throw new IllegalArgumentException("Some of the excel files were not found: " + preconfiguredFiles.keySet());
        }
        return result;
    }

    private File[] sort(File[] files) {
        Arrays.sort(files);
        return files;
    }

    private Map<File, ExcelFileConfig> resolveFiles() {
        HashMap<File, ExcelFileConfig> result = new HashMap<File, ExcelFileConfig>();
        for (ExcelFileConfig fileConfig : this._config.getFileConfigs()) {
            result.put(new File(this._baseDir, fileConfig.getPath()), fileConfig);
        }
        return result;
    }

    private List<ExcelChecker> collectSelective() {
        ArrayList<ExcelChecker> result = new ArrayList<ExcelChecker>();
        for (ExcelFileConfig fileConfig : this._config.getFileConfigs()) {
            if (this.isDeactivated(fileConfig)) continue;
            File excelFile = new File(this._baseDir, fileConfig.getPath());
            BinaryData fileLocation = BinaryDataFactory.createBinaryData((File)excelFile);
            ExcelFileConfig.BasicSheetSet basicSheetSet = fileConfig.getBasicSheetSet();
            List<ExcelSheetConfig> sheetConfigs = fileConfig.getSheetConfigs();
            result.add(new ExcelChecker(excelFile.getName(), fileLocation, basicSheetSet, sheetConfigs));
        }
        return result;
    }

    private boolean isDeactivated(ExcelFileConfig fileConfig) {
        return fileConfig.getBasicSheetSet() == ExcelFileConfig.BasicSheetSet.NONE && fileConfig.getSheetConfigs().isEmpty();
    }

    public static interface ExcelSheetConfig
    extends NamedConfiguration {
        public String getName();

        public SheetOperator getSheetOperator();

        public void setSheetOperator(SheetOperator var1);

        public static enum SheetOperator {
            ADD,
            REMOVE,
            SHEET_DEFINED;

        }
    }

    public static interface ExcelFileConfig
    extends ConfigurationItem {
        public String getPath();

        public void setPath(String var1);

        public BasicSheetSet getBasicSheetSet();

        public void setBasicSheetSet(BasicSheetSet var1);

        public List<ExcelSheetConfig> getSheetConfigs();

        public void setSheetConfigs(List<ExcelSheetConfig> var1);

        public static enum BasicSheetSet {
            NONE,
            FILE_DEFINED,
            ALL;

        }
    }

    public static interface ExcelCollectionConfig
    extends ConfigurationItem {
        public List<ExcelFileConfig> getFileConfigs();

        public void setFileConfigs(List<ExcelFileConfig> var1);

        public BasicFileSet getBasicFileSet();

        public void setBasicFileSet(BasicFileSet var1);

        public static enum BasicFileSet {
            NONE,
            ALL;

        }
    }
}

