/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.excel;

import com.top_logic.base.office.POIUtil;
import com.top_logic.basic.StringServices;
import com.top_logic.basic.UnreachableAssertion;
import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.DefaultConfigConstructorScheme;
import com.top_logic.basic.config.Location;
import com.top_logic.basic.config.LocationImpl;
import com.top_logic.basic.config.TypedConfiguration;
import com.top_logic.basic.shared.collection.CollectionUtilShared;
import com.top_logic.basic.shared.string.StringServicesShared;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.recorder.ref.ModelName;
import com.top_logic.layout.scripting.recorder.ref.value.StringValue;
import com.top_logic.layout.scripting.template.action.BusinessOperationTemplateAction;
import com.top_logic.layout.scripting.template.action.TemplateAction;
import com.top_logic.layout.scripting.template.excel.ExcelActionOp;
import com.top_logic.layout.scripting.template.excel.ExcelActionRegistry;
import com.top_logic.layout.scripting.template.excel.ExcelRowParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;

public class ExcelRow {
    public static final String NO_KEY = "__no_key";
    public static final int RETURN_COLUMN = 0;
    private static final int ACTION_COLUMN = 1;
    private static final int MODEL_COLUMN = 2;
    public static final int CONTEXT_COLUMN = 3;
    public static final int PARAM_COLUMN = 4;
    public static final String CONTEXT_KEY = "kontext";
    public static final String RESULT_KEY = "ergebnis";
    private final List<Object> _rowValues;
    private final String _fileName;
    private final String _sheetName;
    private final Row _row;
    private Map<String, String> _params;

    public ExcelRow(String fileName, String sheetName, Row aRow, List<Object> someRawValues) {
        this._fileName = fileName;
        this._sheetName = sheetName;
        this._row = aRow;
        this._rowValues = CollectionUtilShared.nonNull(someRawValues);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [Excel file: '" + this.getFileName() + "', Sheet: '" + this.getSheetName() + "', Row: " + this.getRowNum() + ", Operation: '" + this.getActionName() + "' '" + this.getModelName() + "'.]";
    }

    public List<Object> getRawValues() {
        return this._rowValues;
    }

    public boolean hasAction() {
        return !StringServices.isEmpty((CharSequence)this.getActionName()) || !StringServices.isEmpty((CharSequence)this.getModelName());
    }

    public ApplicationAction getAction(ExcelActionRegistry.Config excelActionRegistry) throws ConfigurationException {
        String modelName;
        String actionName = this.getActionName();
        Class<? extends ExcelActionOp<?>> theClass = ExcelActionRegistry.getExcelActionOpClass(excelActionRegistry, actionName, modelName = this.getModelName());
        if (theClass == null) {
            return this.findActionScript(modelName, actionName, this.location());
        }
        DefaultConfigConstructorScheme.Factory theFactory = DefaultConfigConstructorScheme.getFactory(theClass);
        Class untypedConfigInterface = theFactory.getConfigurationInterface();
        if (!ExcelActionOp.ExcelAction.class.isAssignableFrom(untypedConfigInterface)) {
            throw new UnreachableAssertion(untypedConfigInterface + " is not a subtype of " + ExcelActionOp.ExcelAction.class + ". Location: " + this);
        }
        Class actionInterface = untypedConfigInterface;
        Object excelAction = new ExcelRowParser().getConfig(actionInterface, this);
        excelAction.setImplementationClass(theClass);
        return excelAction;
    }

    protected ApplicationAction findActionScript(String businessObject, String businessAction, Location location) {
        try {
            BusinessOperationTemplateAction action = this.newItemWithLocation(BusinessOperationTemplateAction.class, location);
            action.setBusinessObject(businessObject);
            action.setBusinessAction(businessAction);
            Map<String, String> parameters = this.convert(this.getParameters());
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                TemplateAction.Parameter parameter = (TemplateAction.Parameter)TypedConfiguration.newConfigItem(TemplateAction.Parameter.class);
                parameter.setName(entry.getKey());
                StringValue stringValue = (StringValue)TypedConfiguration.newConfigItem(StringValue.class);
                stringValue.setString(entry.getValue());
                StringValue value = stringValue;
                parameter.setValue((ModelName)value);
                action.getParameters().add(parameter);
            }
            return action;
        }
        catch (Exception ex) {
            throw new RuntimeException(this + " can not be executed, as loading the script template failed. Cause: " + ex.getMessage(), ex);
        }
    }

    private <T> T newItemWithLocation(Class<T> type, Location location) {
        ConfigurationItem result = TypedConfiguration.getConfigurationDescriptor(type).factory().createNew(location);
        return (T)result;
    }

    private Map<String, String> convert(Map<String, String> parameters) {
        String returnName;
        HashMap<String, String> templateParameters = new HashMap<String, String>(parameters);
        templateParameters.remove(NO_KEY);
        String contextName = this.getContextName();
        if (!StringServices.isEmpty((CharSequence)contextName)) {
            templateParameters.put(CONTEXT_KEY, contextName);
        }
        if (!StringServices.isEmpty((CharSequence)(returnName = this.getReturnName()))) {
            templateParameters.put(RESULT_KEY, returnName);
        }
        return templateParameters;
    }

    public String getReturnName() {
        if (this._rowValues.size() <= 0) {
            return "";
        }
        return StringServicesShared.nonNull((String)((String)this._rowValues.get(0))).trim();
    }

    public String getModelName() {
        if (this._rowValues.size() <= 2) {
            return "";
        }
        return StringServicesShared.nonNull((String)((String)this._rowValues.get(2))).trim();
    }

    public String getActionName() {
        if (this._rowValues.size() <= 1) {
            return "";
        }
        return StringServicesShared.nonNull((String)((String)this._rowValues.get(1))).trim();
    }

    public String getContextName() {
        if (3 >= this._rowValues.size()) {
            return null;
        }
        String[] theKeyValue = this.getKeyValue((String)this._rowValues.get(3));
        String prefix = StringServicesShared.nonNull((String)theKeyValue[0]).trim();
        if (StringServices.isEmpty((String[])theKeyValue) || NO_KEY.equals(prefix)) {
            return null;
        }
        if ("in".equals(prefix)) {
            return StringServicesShared.nonNull((String)theKeyValue[1]).trim();
        }
        throw new IllegalArgumentException("Context has no correct 'in:' prefix. Location: " + this);
    }

    public Map<String, String> getParameters() {
        if (this._params == null) {
            int theSize = this._rowValues.size();
            this._params = new HashMap<String, String>();
            for (int thePos = 4; thePos < theSize; ++thePos) {
                String[] theKeyValue = this.getKeyValue((String)this._rowValues.get(thePos));
                if (theKeyValue == null) continue;
                this._params.put(StringServicesShared.nonNull((String)theKeyValue[0]).trim(), StringServicesShared.nonNull((String)theKeyValue[1]).trim());
            }
        }
        return this._params;
    }

    public <T> T getParameter(String aString) {
        return (T)this.getParameters().get(aString);
    }

    public String[] getKeyValue(String aString) {
        return ExcelRow.getKeyValue(aString, ':');
    }

    public String getName() {
        Row theRow = this.getRow();
        if (theRow != null) {
            int theRowNum = theRow.getRowNum() + 1;
            return this.getSheetName() + "!A" + theRowNum + ":" + POIUtil.getExcelColumnName((int)theRow.getPhysicalNumberOfCells()) + theRowNum;
        }
        return "???";
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getSheetName() {
        return this._sheetName;
    }

    public int getRowNum() {
        return this.getRow().getRowNum() + 1;
    }

    public Row getRow() {
        return this._row;
    }

    public Location location() {
        return ExcelRow.location(this.getFileName(), this.getSheetName(), this.getRowNum());
    }

    private static Location location(final String fileName, final String sheetName, final int rowNum) {
        return new Location(){

            public String getResource() {
                return "file '" + fileName + "' sheet '" + sheetName + "'";
            }

            public int getLine() {
                return rowNum;
            }

            public int getColumn() {
                return 1;
            }

            public String toString() {
                return LocationImpl.toString((Location)this);
            }
        };
    }

    private static String getValueFromString(String aString, int aPos) {
        return aString != null && aPos < aString.length() ? aString.substring(aPos + 1).trim() : null;
    }

    public static String[] getKeyValue(String aString, char aSeparator) {
        int theDiv;
        int n = theDiv = aString != null ? aString.indexOf(aSeparator) : -1;
        if (theDiv < 0) {
            return new String[]{NO_KEY, aString};
        }
        String theKey = aString.substring(0, theDiv).trim();
        String theValue = ExcelRow.getValueFromString(aString, theDiv);
        return new String[]{theKey, theValue};
    }

    public static Map<String, String> getValueMap(String someValues) {
        HashMap<String, String> theValues = new HashMap<String, String>();
        for (String theValue : StringServices.toList((CharSequence)someValues, (char)';')) {
            String[] theKeyValue = ExcelRow.getKeyValue(theValue, '=');
            theValues.put(theKeyValue[0], theKeyValue[1]);
        }
        return theValues;
    }
}

