/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.excel;

import com.top_logic.basic.CollectionUtil;
import com.top_logic.basic.ConfigurationError;
import com.top_logic.basic.config.ConfigBuilder;
import com.top_logic.basic.config.ConfigurationDescriptor;
import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.PropertyDescriptor;
import com.top_logic.basic.config.PropertyDescriptorImpl;
import com.top_logic.basic.config.SimpleInstantiationContext;
import com.top_logic.basic.config.TypedConfiguration;
import com.top_logic.basic.shared.string.StringServicesShared;
import com.top_logic.layout.scripting.template.excel.ExcelActionOp;
import com.top_logic.layout.scripting.template.excel.ExcelRow;
import com.top_logic.layout.scripting.template.excel.Shortcut;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ExcelRowParser {
    private static final InstantiationContext FAIL_IMMEDIATELY_CONTEXT = SimpleInstantiationContext.CREATE_ALWAYS_FAIL_IMMEDIATELY;
    public static final String CONTEXT_PROPERTY = "Kontext";
    public static final String PARAM_PROPERTY = "Parameter";
    public static final String RESULT_PROPERTY = "Ergebnis";

    public <T extends ExcelActionOp.ExcelAction> T getConfig(Class<T> actionClass, ExcelRow aRow) {
        try {
            return this.parse(actionClass, aRow);
        }
        catch (ConfigurationException ex) {
            throw new ConfigurationError("Unparsable configuration at " + aRow.location(), ex);
        }
    }

    private <T extends ExcelActionOp.ExcelAction> T parse(Class<T> actionClass, ExcelRow aRow) throws ConfigurationException {
        ConfigBuilder result = TypedConfiguration.createConfigBuilder(actionClass);
        this.parsParams(aRow, result);
        result.initLocation(aRow.location());
        ExcelActionOp.ExcelAction excelAction = (ExcelActionOp.ExcelAction)actionClass.cast(result.createConfig(FAIL_IMMEDIATELY_CONTEXT));
        excelAction.setFileName(aRow.getFileName());
        excelAction.setSheetName(aRow.getSheetName());
        excelAction.setRowNumber(aRow.getRowNum());
        this.parseContext(aRow, excelAction);
        this.parseReturn(aRow, excelAction);
        this.parseBusinessModel(aRow, excelAction);
        this.parseBusinessAction(aRow, excelAction);
        return (T)excelAction;
    }

    private void parsParams(ExcelRow aRow, ConfigBuilder result) throws ConfigurationException {
        try {
            this.parseParamsUnsafe(aRow, result);
        }
        catch (ConfigurationException ex) {
            throw new ConfigurationException("Failed to parse " + aRow + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void parseReturn(ExcelRow aRow, ExcelActionOp.ExcelAction excelAction) {
        excelAction.setResultName(aRow.getReturnName());
    }

    private void parseContext(ExcelRow aRow, ExcelActionOp.ExcelAction excelAction) {
        excelAction.setContext(aRow.getContextName());
    }

    private void parseParamsUnsafe(ExcelRow aRow, ConfigBuilder result) throws ConfigurationException {
        PropertyDescriptor paramProperty = result.descriptor().getProperty(PARAM_PROPERTY);
        List<Object> theValues = 4 > aRow.getRawValues().size() ? Collections.emptyList() : aRow.getRawValues().subList(4, aRow.getRawValues().size());
        result.update(paramProperty, this.parseValue(aRow, paramProperty, theValues, 4));
    }

    private Object parseValue(ExcelRow aRow, PropertyDescriptor aProperty, List<Object> someCells, int aColumn) throws ConfigurationException {
        switch (aProperty.kind()) {
            case ARRAY: {
                return PropertyDescriptorImpl.listAsArray((PropertyDescriptor)aProperty, this.parseCollectionValue(aRow, aProperty, someCells, aColumn));
            }
            case LIST: {
                return this.parseCollectionValue(aRow, aProperty, someCells, aColumn);
            }
            case ITEM: {
                ConfigBuilder result = TypedConfiguration.createConfigBuilder((Class)aProperty.getType());
                result.initLocation(aRow.location());
                block9: for (Object theCell : someCells) {
                    String[] theKeyValue = aRow.getKeyValue((String)theCell);
                    String theKey = StringServicesShared.nonNull((String)theKeyValue[0]).trim();
                    if ("__no_key".equals(theKey)) continue;
                    String theValue = StringServicesShared.nonNull((String)theKeyValue[1]).trim();
                    PropertyDescriptor contentProperty = result.descriptor().getProperty(theKey);
                    if (contentProperty == null) {
                        throw new IllegalArgumentException("Cannot find property called '" + theKey + "' " + aRow.location() + ".");
                    }
                    Object elementValue = this.parseValue(aRow, contentProperty, theValue, aColumn++);
                    switch (contentProperty.kind()) {
                        case ARRAY: {
                            ArrayList<Object> listValue = new ArrayList<Object>(PropertyDescriptorImpl.arrayAsList((Object)result.value(contentProperty)));
                            listValue.add(elementValue);
                            result.update(contentProperty, (Object)PropertyDescriptorImpl.listAsArray((PropertyDescriptor)contentProperty, listValue));
                            continue block9;
                        }
                        case LIST: {
                            ArrayList<Object> listValue = (ArrayList<Object>)result.value(contentProperty);
                            if (CollectionUtil.isEmptyOrNull((Collection)listValue)) {
                                listValue = new ArrayList();
                            }
                            listValue.add(elementValue);
                            result.update(contentProperty, listValue);
                            continue block9;
                        }
                    }
                    result.update(contentProperty, elementValue);
                }
                return result.createConfig(FAIL_IMMEDIATELY_CONTEXT);
            }
        }
        throw new UnsupportedOperationException("At " + aRow.location() + ".");
    }

    private ArrayList<Object> parseCollectionValue(ExcelRow aRow, PropertyDescriptor aProperty, List<Object> someCells, int aColumn) throws ConfigurationException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object theCell : someCells) {
            String[] value = aRow.getKeyValue((String)theCell);
            result.add(this.parseValue(aRow, aProperty, StringServicesShared.nonNull((String)value[1]).trim(), aColumn++));
        }
        return result;
    }

    private Object parseValue(ExcelRow aRow, PropertyDescriptor aProperty, String aValue, int aColumn) throws ConfigurationException {
        switch (aProperty.kind()) {
            case COMPLEX: 
            case PLAIN: {
                return aProperty.getValueProvider().getValue(aProperty.getPropertyName(), (CharSequence)aValue);
            }
            case ITEM: {
                return this.parseContents(aRow, aValue, aProperty.getType(), aColumn);
            }
            case ARRAY: 
            case LIST: {
                return this.parseContents(aRow, aValue, aProperty.getElementType(), aColumn);
            }
        }
        throw new UnsupportedOperationException("At " + aRow.location() + ".");
    }

    private Object parseContents(ExcelRow aRow, String aValue, Class<?> aType, int aColumn) throws ConfigurationException {
        ConfigBuilder theResult = TypedConfiguration.createConfigBuilder(aType);
        Map<String, String> theValueMap = ExcelRow.getValueMap(aValue);
        theResult.initLocation(aRow.location());
        for (Map.Entry<String, String> entry : theValueMap.entrySet()) {
            PropertyDescriptor theProperty;
            String theValue;
            String theKey = entry.getKey();
            if ("__no_key".endsWith(theKey)) {
                theValue = aValue;
                theProperty = this.getShortcutProperty(theResult.descriptor());
            } else {
                theProperty = theResult.descriptor().getProperty(theKey);
                theValue = entry.getValue();
            }
            theResult.update(theProperty, this.parseValue(aRow, theProperty, theValue, aColumn));
        }
        return theResult.createConfig(FAIL_IMMEDIATELY_CONTEXT);
    }

    private PropertyDescriptor getShortcutProperty(ConfigurationDescriptor aDescriptor) throws ConfigurationException {
        for (PropertyDescriptor theProperty : aDescriptor.getProperties()) {
            if (theProperty.getAnnotation(Shortcut.class) == null) continue;
            return theProperty;
        }
        throw new ConfigurationException("No shortcut property in " + aDescriptor.getConfigurationInterface().getName());
    }

    private void parseBusinessModel(ExcelRow excelRow, ExcelActionOp.ExcelAction action) {
        action.setBusinessModel(excelRow.getModelName());
    }

    private void parseBusinessAction(ExcelRow excelRow, ExcelActionOp.ExcelAction action) {
        action.setBusinessAction(excelRow.getActionName());
    }
}

