/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.excel.format;

import com.top_logic.basic.config.AbstractFormattedConfigurationValueProvider;
import com.top_logic.util.Utils;
import java.text.ParseException;

public class FlexibleBooleanFormat
extends AbstractFormattedConfigurationValueProvider<Boolean> {
    public static final FlexibleBooleanFormat INSTANCE = new FlexibleBooleanFormat();

    public FlexibleBooleanFormat() {
        super(Boolean.class);
    }

    public Boolean parse(String valueString) throws ParseException {
        String theString = valueString.toLowerCase();
        if ("ja".equals(theString) || "wahr".equals(theString) || "yes".equals(theString) || "true".equals(theString)) {
            return Boolean.TRUE;
        }
        if ("nein".equals(theString) || "falsch".equals(theString) || "no".equals(theString) || "false".equals(theString)) {
            return Boolean.FALSE;
        }
        throw new ParseException("Value '" + valueString + "' cannot be translated into a boolean value.", 0);
    }

    public String format(Boolean aConfigValue) {
        return Utils.isTrue((Boolean)aConfigValue) ? "ja" : "nein";
    }
}

