/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.excel.format;

import com.top_logic.basic.DateUtil;
import com.top_logic.basic.col.MapUtil;
import com.top_logic.basic.config.AbstractFormattedConfigurationValueProvider;
import com.top_logic.basic.time.CalendarUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlexibleDateFormat
extends AbstractFormattedConfigurationValueProvider<Date> {
    public static final FlexibleDateFormat INSTANCE = new FlexibleDateFormat();

    public FlexibleDateFormat() {
        super(Date.class);
    }

    public Date parse(String aPropertyValue) throws ParseException {
        return this.parseDate(aPropertyValue);
    }

    public String format(Date aConfigValue) {
        return FlexibleDateFormat.getDateFormat().format(aConfigValue);
    }

    protected Date parseDate(String aParameter) throws ParseException {
        if (aParameter.indexOf(61) < 0) {
            return FlexibleDateFormat.getDateFormat().parse(aParameter);
        }
        Map valueMap = MapUtil.parse((String)aParameter, (String)"=", (String)";");
        return this.parseRelativeDate(valueMap);
    }

    private Date parseRelativeDate(Map<String, String> valueMap) throws ParseException {
        Calendar cal = CalendarUtil.createCalendarInUserTimeZone();
        for (String theKey : valueMap.keySet()) {
            String theValue = valueMap.get(theKey);
            if ("Uhrzeit".equals(theKey) || "Time".equals(theKey)) {
                Pattern timePattern = Pattern.compile("(\\d?\\d):(\\d?\\d)");
                Matcher matcher = timePattern.matcher(theValue.trim());
                if (!matcher.matches()) {
                    throw new IllegalArgumentException(theValue + " does not match pattern HH:mm");
                }
                DateUtil.adjustTime((Calendar)cal, (int)Integer.parseInt(matcher.group(1)), (int)Integer.parseInt(matcher.group(2)), (int)0, (int)0);
                continue;
            }
            char theType = this.parseUnit(theKey);
            cal = DateUtil.add((Calendar)cal, (String)(theValue + theType));
        }
        return cal.getTime();
    }

    private char parseUnit(String unit) throws ParseException {
        if ("Tage".equals(unit) || "Days".equals(unit)) {
            return 'd';
        }
        if ("Monate".equals(unit) || "Month".equals(unit)) {
            return 'M';
        }
        if ("Jahre".equals(unit) || "Years".equals(unit)) {
            return 'y';
        }
        if ("Stunden".equals(unit) || "Hours".equals(unit)) {
            return 'h';
        }
        if ("Minuten".equals(unit) || "Minutes".equals(unit)) {
            return 'm';
        }
        if ("Sekunden".equals(unit) || "Seconds".equals(unit)) {
            return 's';
        }
        throw new ParseException("Unknown unit for date or time: '" + unit + "'.", 0);
    }

    private static DateFormat getDateFormat() {
        return CalendarUtil.newSimpleDateFormat((String)"dd.MM.yyyy");
    }
}

