/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.fuzzy;

import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.annotation.defaults.ClassDefault;
import com.top_logic.layout.VetoException;
import com.top_logic.layout.form.model.AbstractFormField;
import com.top_logic.layout.form.model.BooleanField;
import com.top_logic.layout.form.model.ComplexField;
import com.top_logic.layout.form.model.FormFieldInternals;
import com.top_logic.layout.scripting.action.AbstractFormAction;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.recorder.ref.ModelName;
import com.top_logic.layout.scripting.recorder.ref.ModelResolver;
import com.top_logic.layout.scripting.runtime.ActionContext;
import com.top_logic.layout.scripting.runtime.action.AbstractApplicationActionOp;
import com.top_logic.layout.scripting.runtime.action.ApplicationAssertions;
import com.top_logic.layout.scripting.template.fuzzy.FlexibleFormatKind;
import java.text.DateFormat;
import java.text.Format;

public interface FormFuzzyInput
extends AbstractFormAction {
    @ClassDefault(value=Op.class)
    public Class<? extends AbstractApplicationActionOp<?>> getImplementationClass();

    public String getValue();

    public void setValue(String var1);

    public static class Op
    extends AbstractApplicationActionOp<FormFuzzyInput> {
        public Op(InstantiationContext context, FormFuzzyInput config) {
            super(context, (ApplicationAction)config);
        }

        protected Object processInternal(ActionContext context, Object argument) throws Throwable {
            AbstractFormField field = (AbstractFormField)ModelResolver.locateModel((ActionContext)context, (ModelName)((FormFuzzyInput)this.getConfig()).getField());
            String value = ((FormFuzzyInput)this.getConfig()).getValue();
            if (field instanceof BooleanField) {
                Object parsedValue = FlexibleFormatKind.BOOLEAN.parseValue(value);
                field.setValue(parsedValue);
            } else if (field instanceof ComplexField) {
                ComplexField withFormat = (ComplexField)field;
                Format fieldFormat = withFormat.getFormat();
                if (fieldFormat instanceof DateFormat) {
                    Object fuzzyDate = FlexibleFormatKind.DATE.parseValue(value);
                    String rawValue = fieldFormat.format(fuzzyDate);
                    this.updateField(field, rawValue);
                }
            } else {
                ApplicationAssertions.fail((ConfigurationItem)this.getConfig(), (String)("Field of unsupported type (not boolean or Date): " + field));
            }
            return argument;
        }

        private void updateField(AbstractFormField field, String value) {
            try {
                FormFieldInternals.updateField((AbstractFormField)field, (Object)value);
            }
            catch (VetoException ex) {
                ApplicationAssertions.fail((ConfigurationItem)this.getConfig(), (String)"Field update failed with veto.", (Throwable)ex);
            }
        }
    }
}

