/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.fuzzy;

import com.top_logic.layout.scripting.template.fuzzy.FlexibleFormatKind;
import java.text.ParseException;
import java.util.Date;

public class FuzzyUtil {
    public static <T> T parseFuzzy(Class<T> expectedClass, String formattedValue) throws ParseException {
        if (formattedValue == null) {
            return null;
        }
        Object expectedFuzzy = FuzzyUtil.parseIntern(expectedClass, formattedValue);
        return expectedClass.cast(expectedFuzzy);
    }

    private static Object parseIntern(Class<?> expectedClass, String formattedValue) throws ParseException {
        if (expectedClass == Boolean.class) {
            return FlexibleFormatKind.BOOLEAN.parseValue(formattedValue);
        }
        if (expectedClass == Date.class) {
            return FlexibleFormatKind.DATE.parseValue(formattedValue);
        }
        if (expectedClass == String.class) {
            return formattedValue;
        }
        try {
            if (expectedClass == Long.class) {
                return Long.valueOf(formattedValue);
            }
            if (expectedClass == Integer.class) {
                return Integer.valueOf(formattedValue);
            }
            if (expectedClass == Double.class) {
                return Double.valueOf(formattedValue);
            }
            if (expectedClass == Float.class) {
                return Float.valueOf(formattedValue);
            }
            if (expectedClass == Short.class) {
                return Short.valueOf(formattedValue);
            }
            if (expectedClass == Byte.class) {
                return Byte.valueOf(formattedValue);
            }
        }
        catch (NumberFormatException ex) {
            throw (ParseException)new ParseException("Unable to parse '" + formattedValue + "' as " + expectedClass.getName() + ".", 0).initCause(ex);
        }
        throw new IllegalArgumentException("Unable to fuzzy-parse value to type " + expectedClass + ".");
    }
}

