/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.base.context.TLSubSessionContext;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.annotation.defaults.FormattedDefault;
import com.top_logic.layout.DisplayContext;
import com.top_logic.layout.FrameScope;
import com.top_logic.layout.scripting.runtime.LiveActionContext;
import com.top_logic.layout.scripting.runtime.execution.DefaultScriptController;
import com.top_logic.layout.scripting.runtime.execution.LiveActionExecutor;
import com.top_logic.layout.scripting.runtime.execution.ScriptController;
import com.top_logic.layout.scripting.runtime.execution.ScriptDriver;
import com.top_logic.layout.scripting.template.gui.ActionReplayCommand;
import com.top_logic.layout.scripting.template.gui.DisabledWhenBuzzy;
import com.top_logic.layout.scripting.template.gui.ScriptRecorderTree;
import com.top_logic.layout.tree.model.DefaultMutableTLTreeNode;
import com.top_logic.layout.tree.model.TLTreeNode;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.boundsec.CommandGroupReference;
import com.top_logic.tool.boundsec.HandlerResult;
import com.top_logic.tool.execution.CombinedExecutabilityRule;
import com.top_logic.tool.execution.ExecutabilityRule;
import com.top_logic.tool.execution.NoSelectionDisabled;
import com.top_logic.util.TLContextManager;
import java.util.Map;

public final class ApplyApplicationAction
extends ActionReplayCommand {
    private static final String I18N_NO_ACTION = "tl.scripting.applyAction.noAction";
    private Mode _mode;

    public ApplyApplicationAction(InstantiationContext context, Config config) {
        super(context, config);
        this._mode = config.getMode();
    }

    public HandlerResult handleCommand(DisplayContext displayContext, LayoutComponent component, Object model, Map<String, Object> arguments) {
        ScriptRecorderTree scriptRecorder = (ScriptRecorderTree)component;
        LiveActionContext actionContext = new LiveActionContext(displayContext, component);
        DefaultMutableTLTreeNode selection = scriptRecorder.getSelectedNode();
        if (selection == null) {
            return HandlerResult.error((String)I18N_NO_ACTION, ApplyApplicationAction.class);
        }
        String currentUserName = TLContextManager.getCurrentUserName((TLSubSessionContext)displayContext.getSubSessionContext());
        DefaultScriptController controller = new DefaultScriptController(currentUserName, (TLTreeNode)selection);
        switch (this._mode) {
            case STEP_INTO: {
                controller.setBreakPoint(DefaultScriptController.followingNode((TLTreeNode)selection));
                controller.setBreakPoint(DefaultScriptController.followingSibling((TLTreeNode)selection));
                break;
            }
            case STEP_OUT: {
                if (selection.getParent() == null) break;
                controller.setBreakPoint(DefaultScriptController.followingSibling((TLTreeNode)selection.getParent()));
                break;
            }
            case STEP_OVER: {
                controller.setBreakPoint(DefaultScriptController.followingSibling((TLTreeNode)selection));
                break;
            }
        }
        LiveActionExecutor executor = new LiveActionExecutor(actionContext, (ScriptController)controller, (Object)currentUserName, true, exec -> {
            ApplyApplicationAction.stopExecution((LayoutComponent)scriptRecorder);
            TLTreeNode current = exec.scriptPosition();
            TLTreeNode failedNode = current == null ? scriptRecorder.getTreeData().getTreeModel().getRoot() : current;
            scriptRecorder.setSelected(failedNode);
        });
        ApplyApplicationAction.setCurrentExecution((LayoutComponent)scriptRecorder, (ScriptController)controller);
        ScriptDriver scriptDriver = new ScriptDriver((FrameScope)scriptRecorder.getEnclosingFrameScope(), executor);
        scriptRecorder.set(ScriptRecorderTree.SCRIPT_DRIVER, scriptDriver);
        return scriptDriver.next(displayContext);
    }

    public ExecutabilityRule createExecutabilityRule() {
        return CombinedExecutabilityRule.combine((ExecutabilityRule)NoSelectionDisabled.INSTANCE, (ExecutabilityRule)DisabledWhenBuzzy.INSTANCE);
    }

    public static enum Mode {
        STEP_INTO,
        STEP_OUT,
        STEP_OVER,
        PLAY;

    }

    public static interface Config
    extends AbstractCommandHandler.Config {
        public Mode getMode();

        @FormattedDefault(value="System")
        public CommandGroupReference getGroup();
    }
}

