/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.basic.UnreachableAssertion;
import com.top_logic.basic.util.Utils;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.runtime.execution.DefaultScriptController;
import com.top_logic.layout.scripting.runtime.execution.EnvironmentMismatch;
import com.top_logic.layout.scripting.runtime.execution.WaitTimeoutException;
import com.top_logic.layout.tree.model.TLTreeNode;
import java.util.HashSet;
import java.util.Set;

public class MultiUserScriptController
extends DefaultScriptController {
    private static final long TIMEOUT = 10000L;
    private final Set<String> _activeUsers = new HashSet<String>();

    public MultiUserScriptController(String currentUserName, TLTreeNode<?> root) {
        super(currentUserName, root);
    }

    public synchronized void loginUser(String userName) {
        this._activeUsers.add(userName);
    }

    public synchronized void logoutUser(String userName) {
        super.logoutUser(userName);
        this._activeUsers.remove(userName);
    }

    public synchronized void stop() {
        super.stop();
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized boolean isStopped() {
        return super.isStopped();
    }

    protected synchronized boolean internalHasNext(Object processId, boolean login) throws WaitTimeoutException {
        if (this.hasNext()) {
            if (this.acceptAction(processId, login)) {
                return true;
            }
            return this.waitForNext(processId, login);
        }
        return false;
    }

    private boolean waitForNext(Object processId, boolean login) throws WaitTimeoutException {
        block3: {
            long startTime = System.currentTimeMillis();
            long timeout = 10000L;
            do {
                try {
                    ((Object)((Object)this)).wait(timeout);
                    long sleepTime = System.currentTimeMillis() - startTime;
                    timeout = 10000L - sleepTime;
                }
                catch (InterruptedException ex) {
                    return false;
                }
                if (!this.hasNext()) break block3;
                if (!this.acceptAction(processId, login)) continue;
                return true;
            } while (timeout > 0L);
            throw new WaitTimeoutException();
        }
        return false;
    }

    protected boolean acceptAction(Object processId, boolean login) {
        String currentUser = this.currentUser();
        if (login && this.noSession(currentUser)) {
            return true;
        }
        return Utils.equals((Object)currentUser, (Object)processId);
    }

    private boolean noSession(String currentUser) {
        return !this.hasSession(currentUser);
    }

    public boolean hasSession(String currentUser) {
        return this._activeUsers.contains(currentUser);
    }

    public synchronized ApplicationAction current() {
        return this.internalCurrent();
    }

    private ApplicationAction internalCurrent() {
        try {
            return super.current();
        }
        catch (EnvironmentMismatch ex) {
            throw new UnreachableAssertion((Throwable)ex);
        }
    }

    protected void checkUser(ApplicationAction action) throws EnvironmentMismatch {
    }

    public synchronized void next() {
        super.next();
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized void nextSibling() {
        super.nextSibling();
        ((Object)((Object)this)).notifyAll();
    }
}

