/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.basic.StringServices;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.PolymorphicConfiguration;
import com.top_logic.basic.config.annotation.defaults.FormattedDefault;
import com.top_logic.basic.config.annotation.defaults.ListDefault;
import com.top_logic.basic.config.annotation.defaults.StringDefault;
import com.top_logic.basic.util.ResKey;
import com.top_logic.layout.DisplayContext;
import com.top_logic.layout.basic.ThemeImage;
import com.top_logic.layout.scripting.template.gui.I18NConstants;
import com.top_logic.layout.scripting.template.gui.ScriptContainer;
import com.top_logic.layout.scripting.template.gui.ServerScriptSelectorExecutability;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.boundsec.CommandGroupReference;
import com.top_logic.tool.boundsec.HandlerResult;
import com.top_logic.tool.execution.ExecutabilityRule;
import com.top_logic.tool.execution.ExecutableState;
import java.util.List;
import java.util.Map;

public class SaveScriptCommand
extends AbstractCommandHandler {
    public static final String COMMAND_ID = "saveScript";

    public SaveScriptCommand(InstantiationContext context, Config config) {
        super(context, (AbstractCommandHandler.Config)config);
    }

    public HandlerResult handleCommand(DisplayContext context, LayoutComponent component, Object model, Map<String, Object> arguments) {
        ScriptContainer script = (ScriptContainer)model;
        if (script == null) {
            return HandlerResult.error((ResKey)I18NConstants.SAVE_SCRIPT_ERROR_NO_SCRIPT_FILE);
        }
        if (!(script instanceof ScriptContainer.PersistableScriptContainer)) {
            return HandlerResult.error((ResKey)I18NConstants.SAVE_SCRIPT_ERROR_SCRIPT_NOT_SAVABLE);
        }
        ScriptContainer.PersistableScriptContainer persistableScript = (ScriptContainer.PersistableScriptContainer)script;
        persistableScript.persist();
        return HandlerResult.DEFAULT_RESULT;
    }

    public static interface Config
    extends AbstractCommandHandler.Config {
        public static final String DEFAULT_VALUE_ID = "saveScript";
        public static final String DEFAULT_IMAGE = "theme:SAVE_SCRIPT";

        @StringDefault(value="saveScript")
        public String getId();

        @StringDefault(value="additional-apply")
        public String getClique();

        @FormattedDefault(value="System")
        public CommandGroupReference getGroup();

        @ListDefault(value={ServerScriptSelectorExecutability.class, Executability.class})
        public List<PolymorphicConfiguration<? extends ExecutabilityRule>> getExecutability();

        @FormattedDefault(value="theme:SAVE_SCRIPT")
        public ThemeImage getImage();
    }

    public static final class Executability
    implements ExecutabilityRule {
        public ExecutableState isExecutable(LayoutComponent component, Object model, Map<String, Object> values) {
            if (model == null) {
                return ExecutableState.createDisabledState((ResKey)I18NConstants.SAVE_SCRIPT_ERROR_NO_SCRIPT_FILE);
            }
            if (!(model instanceof ScriptContainer)) {
                throw new RuntimeException("Invalid model. Expected a " + ScriptContainer.class.getSimpleName() + " but found: " + StringServices.debug((Object)model));
            }
            ScriptContainer script = (ScriptContainer)model;
            if (!(script instanceof ScriptContainer.PersistableScriptContainer)) {
                return ExecutableState.createDisabledState((ResKey)I18NConstants.SAVE_SCRIPT_ERROR_SCRIPT_NOT_SAVABLE);
            }
            return ExecutableState.EXECUTABLE;
        }
    }
}

