/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.basic.StringServices;
import com.top_logic.basic.io.FileUtilities;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.recorder.ActionWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class ScriptContainer {
    private ApplicationAction _action;

    private ScriptContainer(ApplicationAction action) {
        this._action = ScriptContainer.checkNonNull(action);
    }

    public static ScriptContainer createTransient(ApplicationAction action) {
        return new ScriptContainer(action);
    }

    public static PersistableScriptContainer createPersistable(ApplicationAction action, File file) {
        return new PersistableScriptContainer(action, file);
    }

    public ApplicationAction getAction() {
        return this._action;
    }

    public void setAction(ApplicationAction newAction) {
        this._action = ScriptContainer.checkNonNull(newAction);
    }

    private static <T> T checkNonNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static final class PersistableScriptContainer
    extends ScriptContainer {
        private final File _file;

        private PersistableScriptContainer(ApplicationAction action, File file) {
            super(action);
            this._file = ScriptContainer.checkNonNull(file);
        }

        public void persist() {
            this.writeToFile(ActionWriter.INSTANCE.writeAction(this.getAction(), true, true));
        }

        private void writeToFile(String content) {
            try {
                Charset fileEncoding = StringServices.CHARSET_UTF_8;
                FileUtilities.writeStringToFile((String)content, (File)this._file, (Charset)fileEncoding);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to persist the action. File: '" + FileUtilities.getSafeDetailedPath((File)this._file) + "'; Cause: " + ex.getMessage(), ex);
            }
        }
    }
}

