/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.annotation.defaults.ItemDefault;
import com.top_logic.basic.xml.XMLPrettyPrinter;
import com.top_logic.layout.codeedit.control.CodeEditorControl;
import com.top_logic.layout.form.FormField;
import com.top_logic.layout.form.FormMember;
import com.top_logic.layout.form.ValueListener;
import com.top_logic.layout.form.component.FormComponent;
import com.top_logic.layout.form.model.FormContext;
import com.top_logic.layout.form.template.ControlProvider;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.runtime.ActionField;
import com.top_logic.layout.scripting.template.gui.ScriptRecorderTree;
import com.top_logic.layout.tree.model.MutableTLTreeNode;
import com.top_logic.layout.tree.model.TLTreeNode;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.util.Utils;

public class ScriptRecorderComponent
extends FormComponent {
    public static final String FIELD_NAME_EDIT_ACTION = "editAction";
    public static final String ACTION_FIELD_CSS_CLASS = "scriptRecorderActionXmlField";
    private final ValueListener editActionListener = new ValueListener(){

        public void valueChanged(FormField editActionFieldViaParameter, Object oldActionXml, Object newActionXml) {
            ScriptRecorderComponent.this.reactOnNewActionXml((ApplicationAction)newActionXml);
        }
    };

    public ScriptRecorderComponent(InstantiationContext context, Config config) throws ConfigurationException {
        super(context, (FormComponent.Config)config);
    }

    public FormContext createFormContext() {
        FormContext formContext = new FormContext((LayoutComponent)this);
        FormField editableActionField = ActionField.newActionField((String)FIELD_NAME_EDIT_ACTION, (boolean)false, (boolean)false, null, (XMLPrettyPrinter.Config)((Config)this._config).getXMLDisplay());
        editableActionField.setControlProvider((ControlProvider)new CodeEditorControl.CP("ace/mode/xml"));
        formContext.addMember((FormMember)editableActionField);
        this.updateActionFields(editableActionField);
        editableActionField.addValueListener(this.editActionListener);
        editableActionField.setCssClasses(ACTION_FIELD_CSS_CLASS);
        return formContext;
    }

    private void reactOnNewActionXml(ApplicationAction newAction) {
        MutableTLTreeNode model = (MutableTLTreeNode)this.getModel();
        if (Utils.equals((Object)ScriptRecorderTree.action(model), (Object)newAction)) {
            return;
        }
        model.setBusinessObject((Object)newAction);
        this.fireModelModifiedEvent(model, (Object)this);
    }

    protected boolean receiveModelChangedEvent(Object aModel, Object changedBy) {
        boolean result = super.receiveModelChangedEvent(aModel, changedBy);
        if (aModel == this.getModel()) {
            this.removeFormContext();
        }
        return result;
    }

    protected boolean supportsInternalModel(Object object) {
        return object instanceof TLTreeNode;
    }

    protected void updateForm() {
        if (this.hasFormContext()) {
            this.updateActionFields(this.getFormContext().getField(FIELD_NAME_EDIT_ACTION));
        }
    }

    protected void handleNewModel(Object newModel) {
    }

    private void updateActionFields(FormField editableActionField) {
        ApplicationAction newAction = ScriptRecorderTree.action(this.getModel());
        editableActionField.setValue((Object)newAction);
        if (newAction == null) {
            editableActionField.setImmutable(true);
        } else if (ScriptRecorderTree.isDerived((TLTreeNode)this.getModel())) {
            editableActionField.setDisabled(true);
        } else {
            editableActionField.setDisabled(false);
        }
    }

    public static interface Config
    extends FormComponent.Config {
        @ItemDefault
        public XMLPrettyPrinter.Config getXMLDisplay();
    }
}

