/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.basic.CollectionUtil;
import com.top_logic.basic.Log;
import com.top_logic.basic.col.DescendantDFSIterator;
import com.top_logic.basic.col.Maybe;
import com.top_logic.basic.col.TreeView;
import com.top_logic.basic.col.TypedAnnotatable;
import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.PolymorphicConfiguration;
import com.top_logic.basic.config.SimpleInstantiationContext;
import com.top_logic.basic.config.TypedConfiguration;
import com.top_logic.basic.config.annotation.Name;
import com.top_logic.basic.config.annotation.defaults.ItemDefault;
import com.top_logic.basic.util.ResKey;
import com.top_logic.basic.xml.TagUtil;
import com.top_logic.layout.Control;
import com.top_logic.layout.DisplayContext;
import com.top_logic.layout.IndexPosition;
import com.top_logic.layout.basic.CommandModel;
import com.top_logic.layout.basic.DefaultDisplayContext;
import com.top_logic.layout.basic.ThemeImage;
import com.top_logic.layout.component.Selectable;
import com.top_logic.layout.component.model.SelectionListener;
import com.top_logic.layout.scripting.action.ActionChain;
import com.top_logic.layout.scripting.action.ActionFactory;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.action.DynamicAction;
import com.top_logic.layout.scripting.recorder.ScriptingRecorder;
import com.top_logic.layout.scripting.runtime.ActionContext;
import com.top_logic.layout.scripting.runtime.LiveActionContext;
import com.top_logic.layout.scripting.runtime.action.DynamicActionOp;
import com.top_logic.layout.scripting.runtime.execution.ScriptDriver;
import com.top_logic.layout.scripting.template.gui.ActionTreeRenderer;
import com.top_logic.layout.scripting.template.gui.I18NConstants;
import com.top_logic.layout.scripting.template.gui.ScriptContainer;
import com.top_logic.layout.scripting.template.gui.ScriptRecorderTreeControl;
import com.top_logic.layout.scripting.template.gui.ScriptingRecorderDropTarget;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateResource;
import com.top_logic.layout.structure.ControlRepresentable;
import com.top_logic.layout.structure.ControlRepresentableCP;
import com.top_logic.layout.structure.LayoutControlProvider;
import com.top_logic.layout.tree.DefaultTreeData;
import com.top_logic.layout.tree.TreeData;
import com.top_logic.layout.tree.TreeDataOwner;
import com.top_logic.layout.tree.TreeRenderer;
import com.top_logic.layout.tree.dnd.DefaultTreeDrag;
import com.top_logic.layout.tree.dnd.TreeDragSource;
import com.top_logic.layout.tree.dnd.TreeDropTarget;
import com.top_logic.layout.tree.model.AbstractMutableTLTreeNode;
import com.top_logic.layout.tree.model.DefaultMutableTLTreeModel;
import com.top_logic.layout.tree.model.DefaultMutableTLTreeNode;
import com.top_logic.layout.tree.model.DefaultMutableTreeNodeBuilder;
import com.top_logic.layout.tree.model.DefaultStructureTreeUIModel;
import com.top_logic.layout.tree.model.MutableTLTreeModel;
import com.top_logic.layout.tree.model.TLTreeModel;
import com.top_logic.layout.tree.model.TLTreeNode;
import com.top_logic.layout.tree.model.TreeBuilder;
import com.top_logic.layout.tree.model.TreeModelEvent;
import com.top_logic.layout.tree.model.TreeModelListener;
import com.top_logic.layout.tree.model.TreeUIModel;
import com.top_logic.mig.html.DefaultSingleSelectionModel;
import com.top_logic.mig.html.SelectionModel;
import com.top_logic.mig.html.SelectionModelOwner;
import com.top_logic.mig.html.layout.CommandRegistry;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractSystemCommand;
import com.top_logic.tool.boundsec.BoundComponent;
import com.top_logic.tool.boundsec.HandlerResult;
import com.top_logic.tool.execution.CombinedExecutabilityRule;
import com.top_logic.tool.execution.ExecutabilityRule;
import com.top_logic.tool.execution.ExecutableState;
import com.top_logic.tool.execution.NoSelectionDisabled;
import com.top_logic.util.TLContext;
import com.top_logic.util.Utils;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScriptRecorderTree
extends BoundComponent
implements TreeDataOwner,
Selectable,
ControlRepresentable {
    public static final TypedAnnotatable.Property<DefaultMutableTLTreeNode> CLIPBOARD = TypedAnnotatable.property(DefaultMutableTLTreeNode.class, (String)"clipboard");
    private static final TypedAnnotatable.Property<Boolean> DERIVED = TypedAnnotatable.property(Boolean.class, (String)"derived", (Object)Boolean.FALSE);
    private static final TypedAnnotatable.Property<String> ERROR = TypedAnnotatable.property(String.class, (String)"error");
    private final SelectionListener uiSelectionForwarder = new SelectionListener(){

        public void notifySelectionChanged(SelectionModel model, Set<?> formerlySelectedObjects, Set<?> selectedObjects) {
            TLTreeNode selectedNode = (TLTreeNode)CollectionUtil.getSingleValueFromCollection(selectedObjects);
            ScriptRecorderTree.this.setSelected(selectedNode);
        }
    };
    private final TreeModelListener selectCollapsedNodeListener = new TreeModelListener(){

        public void handleTreeUIModelEvent(TreeModelEvent event) {
            if (event.getType() != 4) {
                return;
            }
            TLTreeNode collapsedNode = (TLTreeNode)event.getNode();
            if (!ScriptRecorderTree.this.isNothingSelected() && ScriptRecorderTree.this.isAncestor((TLTreeNode<?>)collapsedNode, (TLTreeNode<?>)ScriptRecorderTree.this.getSelectedNode())) {
                ScriptRecorderTree.this.setSelected(collapsedNode);
            }
        }
    };
    public static TypedAnnotatable.Property<ScriptDriver> SCRIPT_DRIVER = TypedAnnotatable.property(ScriptDriver.class, (String)"scriptDriver");
    private Iterator<ScriptingRecorder.Event> eventSource;
    private TreeData _uiModel;
    private boolean _isRecording = false;
    private final TreeDragSource _dragSource;
    private final TreeDropTarget _dropTarget;

    public ScriptRecorderTree(InstantiationContext context, Config config) throws ConfigurationException {
        super(context, (BoundComponent.Config)config);
        this._dragSource = (TreeDragSource)context.getInstance(config.getTreeDragSource());
        this._dropTarget = (TreeDropTarget)context.getInstance(config.getTreeDropTarget());
    }

    public TreeData getTreeData() {
        return this.getUIModel();
    }

    public boolean isRecording() {
        return this._isRecording;
    }

    private void startRecording() {
        ScriptingRecorder.getInstance().setRecordingActive(true);
        this._isRecording = true;
        this.enableEventQueue();
    }

    private void stopRecording() {
        ScriptingRecorder.getInstance().setRecordingActive(false);
        this._isRecording = false;
        this.freezeEventQueue();
    }

    private void enableEventQueue() {
        this.eventSource = ScriptingRecorder.getInstance().getEventPointer();
        assert (this.eventSource != null) : "Failed to attach to ScriptRecorder.";
    }

    private void freezeEventQueue() {
        if (this.eventSource != null) {
            this.eventSource = CollectionUtil.toList(this.eventSource).iterator();
        }
    }

    public Control getRenderingControl() {
        return new ScriptRecorderTreeControl(this.getUIModel(), this);
    }

    public boolean isModelValid() {
        return this._uiModel != null && (this.eventSource == null || !this.eventSource.hasNext()) && super.isModelValid();
    }

    public boolean validateModel(DisplayContext context) {
        boolean result = super.validateModel(context);
        if (this.getModel() == null) {
            this.setModel(ScriptContainer.createTransient((ApplicationAction)ActionFactory.actionChain((ApplicationAction[])new ApplicationAction[0])));
            result = true;
        }
        DefaultMutableTLTreeNode newNode = null;
        while (this.eventSource != null && this.eventSource.hasNext()) {
            ScriptingRecorder.Event event = this.eventSource.next();
            if (!Utils.equals((Object)event.getSessionId(), (Object)TLContext.getContext().getSessionContext().getId())) continue;
            newNode = this.insertAction(event.getAction());
        }
        if (newNode != null) {
            this.fireModelEvent(this.getModel(), 1);
        }
        if (this._uiModel == null) {
            DefaultMutableTLTreeModel treeModel = new DefaultMutableTLTreeModel((TreeBuilder)DefaultMutableTreeNodeBuilder.INSTANCE, (Object)this.getModelTyped().getAction());
            DefaultStructureTreeUIModel treeUiModel = new DefaultStructureTreeUIModel((TLTreeModel)treeModel);
            treeUiModel.addTreeModelListener(this.selectCollapsedNodeListener);
            DefaultSingleSelectionModel selectionModel = new DefaultSingleSelectionModel(SelectionModelOwner.NO_OWNER);
            ActionTreeRenderer renderer = new ActionTreeRenderer();
            this._uiModel = new DefaultTreeData(Maybe.some((Object)((Object)this)), (TreeUIModel)treeUiModel, (SelectionModel)selectionModel, (TreeRenderer)renderer, this._dragSource, this._dropTarget);
            ScriptingRecorder.annotateAsDontRecord((TypedAnnotatable)this._uiModel);
            selectionModel.addSelectionListener(this.uiSelectionForwarder);
            this.setSelected(this.getRoot());
        }
        return result;
    }

    protected boolean receiveModelCreatedEvent(Object model, Object changedBy) {
        boolean result = super.receiveModelCreatedEvent(model, changedBy);
        if (model instanceof ApplicationAction) {
            this.insertAction((ApplicationAction)model);
        }
        return result;
    }

    protected boolean receiveModelChangedEvent(Object model, Object changedBy) {
        if (model instanceof TemplateResource) {
            this.updateChildren(this.getRoot(), (ApplicationAction)this.getRoot().getBusinessObject(), false);
        } else if (this.getSelected() == model) {
            DefaultMutableTLTreeNode node = (DefaultMutableTLTreeNode)model;
            this.setAction(node, (ApplicationAction)node.getBusinessObject());
        }
        return super.receiveModelChangedEvent(model, changedBy);
    }

    DefaultMutableTLTreeNode insertAction(ApplicationAction newAction) {
        int insertIndex;
        DefaultMutableTLTreeNode parent;
        DefaultMutableTLTreeNode reference;
        for (reference = this.getSelectedNode(); reference != null && ScriptRecorderTree.isDerived(reference); reference = (DefaultMutableTLTreeNode)reference.getParent()) {
        }
        if (reference == null || reference == this.getRoot()) {
            parent = this.getRoot();
            insertIndex = parent.getChildCount();
        } else {
            parent = (DefaultMutableTLTreeNode)reference.getParent();
            insertIndex = 1 + parent.getIndex((Object)reference);
        }
        IndexPosition position = IndexPosition.before((int)insertIndex++);
        DefaultMutableTLTreeNode newNode = this.createNode(parent, position, newAction);
        this.setSelected(newNode);
        return newNode;
    }

    private ScriptContainer getModelTyped() {
        return (ScriptContainer)this.getModel();
    }

    protected void handleNewModel(Object newModel) {
        super.handleNewModel(newModel);
        if (this.getUIModel() == null) {
            return;
        }
        ScriptContainer newScriptContainer = (ScriptContainer)newModel;
        this.enforceActionChainAsRoot(newScriptContainer);
        this.setAction(this.getRoot(), newScriptContainer.getAction());
        this.setSelected(this.getRoot());
        this.fireModelModifiedEvent(this.getRoot(), (Object)this);
    }

    private void enforceActionChainAsRoot(ScriptContainer newScriptContainer) {
        if (newScriptContainer.getAction() instanceof ActionChain) {
            return;
        }
        newScriptContainer.setAction((ApplicationAction)ActionFactory.actionChain((ApplicationAction[])new ApplicationAction[]{newScriptContainer.getAction()}));
        this.fireModelModifiedEvent();
    }

    private void fireModelModifiedEvent() {
        this.fireModelModifiedEvent(this.getModel(), (Object)this);
    }

    private TreeData getUIModel() {
        return this._uiModel;
    }

    protected boolean supportsInternalModel(Object object) {
        return object instanceof ScriptContainer;
    }

    static boolean isDerived(TLTreeNode<?> node) {
        return (Boolean)node.get(DERIVED);
    }

    static boolean hasError(TLTreeNode<?> node) {
        return ScriptRecorderTree.getError(node) != null;
    }

    static String getError(TLTreeNode<?> node) {
        return (String)node.get(ERROR);
    }

    private void expandPathToNode(TLTreeNode<?> node) {
        if (node == null || Utils.equals(node, (Object)this.getRoot())) {
            return;
        }
        TLTreeNode parent = node;
        while ((parent = parent.getParent()) != null) {
            this.getTreeUiModel().setExpanded((Object)parent, true);
            if (!Utils.equals((Object)parent, (Object)this.getRoot())) continue;
        }
    }

    private static List<ApplicationAction> actions(DefaultMutableTLTreeNode parent) {
        return ScriptRecorderTree.actionChain(parent).getActions();
    }

    static ActionChain actionChain(DefaultMutableTLTreeNode parent) {
        return (ActionChain)ScriptRecorderTree.action(parent);
    }

    public static Boolean isActionNode(Object node) {
        return ScriptRecorderTree.action(node) != null;
    }

    public static ApplicationAction action(Object node) {
        if (!(node instanceof TLTreeNode)) {
            return null;
        }
        return ScriptRecorderTree.action((TLTreeNode)node);
    }

    public static ApplicationAction action(TLTreeNode<?> node) {
        if (node == null) {
            return null;
        }
        Object businessObject = node.getBusinessObject();
        if (!(businessObject instanceof ApplicationAction)) {
            return null;
        }
        return (ApplicationAction)businessObject;
    }

    private void setAction(DefaultMutableTLTreeNode node, ApplicationAction action) {
        DefaultMutableTLTreeNode parent = (DefaultMutableTLTreeNode)node.getParent();
        if (parent != null) {
            int parentIndex = parent.getIndex((Object)node);
            ScriptRecorderTree.actions(parent).set(parentIndex, action);
        }
        node.setBusinessObject((Object)action);
        if (node == this.getRoot()) {
            this.getModelTyped().setAction(action);
            this.fireModelModifiedEvent();
        }
        this.fireModelModifiedEvent(node, (Object)this);
        this.updateChildren(node, action, ScriptRecorderTree.isDerived(node));
    }

    private void updateChildren(DefaultMutableTLTreeNode node, ApplicationAction action, boolean derived) {
        node.clearChildren();
        if (action instanceof ActionChain) {
            ActionChain chain = (ActionChain)action;
            List parts = chain.getActions();
            this.importChildren(node, parts, derived);
        } else if (action instanceof DynamicAction) {
            DynamicActionOp actionOp = (DynamicActionOp)SimpleInstantiationContext.CREATE_ALWAYS_FAIL_IMMEDIATELY.getInstance((PolymorphicConfiguration)action);
            try {
                List children = actionOp.createActions((ActionContext)new LiveActionContext(DefaultDisplayContext.getDisplayContext(), (LayoutComponent)this));
                this.importChildren(node, children, true);
                node.set(ERROR, null);
            }
            catch (Exception ex) {
                Object message = ex.getMessage();
                for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                    int last;
                    for (last = ((String)message).length() - 1; last >= 0 && !Character.isLetterOrDigit(((String)message).charAt(last)); --last) {
                    }
                    String prefix = ((String)message).substring(0, last + 1);
                    message = prefix + ": " + cause.getClass().getSimpleName() + ": " + cause.getMessage();
                }
                node.set(ERROR, message);
            }
        }
    }

    private void importChildren(DefaultMutableTLTreeNode target, List<ApplicationAction> innerActions, boolean derived) {
        target.clearChildren();
        for (ApplicationAction action : innerActions) {
            DefaultMutableTLTreeNode child = (DefaultMutableTLTreeNode)target.createChild((Object)action);
            if (derived) {
                child.set(DERIVED, (Object)Boolean.TRUE);
            }
            this.updateChildren(child, action, derived);
        }
    }

    private boolean isRootSelected() {
        return this.getSelectedNode() == this.getRoot();
    }

    private boolean isNothingSelected() {
        return this.getSelectedNode() == null;
    }

    final DefaultMutableTLTreeNode getSelectedNode() {
        return (DefaultMutableTLTreeNode)this.getSelected();
    }

    public boolean setSelectedAction(ApplicationAction newSelectedAction) {
        boolean change;
        ApplicationAction oldSelectedAction = ScriptRecorderTree.action(this.getSelectedNode());
        boolean bl = change = newSelectedAction != oldSelectedAction;
        if (!change) {
            return false;
        }
        TLTreeNode newSelectedNode = newSelectedAction == null ? null : (TLTreeNode)this.findNodeWithBusinessObject(newSelectedAction).getElse(null);
        return this.setSelected(newSelectedNode);
    }

    private SelectionModel getSelectionModel() {
        TreeData uiModel = this.getUIModel();
        if (uiModel == null) {
            return null;
        }
        return uiModel.getSelectionModel();
    }

    private List<Integer> createIndexPathToNode(TLTreeNode<?> node) {
        ArrayList<Integer> indexPathToNode = new ArrayList<Integer>();
        while (!Utils.equals(node, (Object)this.getRoot())) {
            indexPathToNode.add(node.getParent().getIndex(node));
            node = node.getParent();
        }
        Collections.reverse(indexPathToNode);
        return indexPathToNode;
    }

    private TLTreeNode<?> getNodeByIndexPath(List<Integer> indexPath) {
        DefaultMutableTLTreeNode node = this.getRoot();
        for (Integer index : indexPath) {
            node = node.getChildAt(index.intValue());
        }
        return node;
    }

    DefaultMutableTLTreeNode createNode(DefaultMutableTLTreeNode parent, IndexPosition position, ApplicationAction newAction) {
        DefaultMutableTLTreeNode newNode = (DefaultMutableTLTreeNode)parent.createChild(position, (Object)newAction);
        this.updateActionChain(parent, position, newAction, newNode);
        return newNode;
    }

    void updateActionChain(DefaultMutableTLTreeNode parent, IndexPosition position, ApplicationAction newAction, DefaultMutableTLTreeNode newNode) {
        List<ApplicationAction> parentActions = ScriptRecorderTree.actions(parent);
        parentActions.add(position.beforeIndex(parentActions), newAction);
        this.updateChildren(newNode, newAction, false);
    }

    private void deleteNode(DefaultMutableTLTreeNode node) {
        boolean isSelected = Utils.equals((Object)this.getSelectedNode(), (Object)node);
        if (isSelected) {
            this.setSelected(this.findAfterDeleteSelection(node));
        }
        this.internalDeleteNode(node);
    }

    private void internalDeleteNode(DefaultMutableTLTreeNode node) {
        DefaultMutableTLTreeNode parent = (DefaultMutableTLTreeNode)node.getParent();
        int removedIndex = parent.getIndex((Object)node);
        parent.removeChild(removedIndex);
        ScriptRecorderTree.actions(parent).remove(removedIndex);
    }

    void insertNodeForAction(ApplicationAction action) {
        DefaultMutableTLTreeNode selected = this.getSelectedNode();
        DefaultMutableTLTreeNode parent = (DefaultMutableTLTreeNode)selected.getParent();
        DefaultMutableTLTreeNode newChild = parent == null ? this.createNode(selected, IndexPosition.END, action) : this.createNode(parent, IndexPosition.after((int)parent.getIndex((Object)selected)), action);
        this.setSelected(newChild);
    }

    private DefaultMutableTLTreeNode findAfterDeleteSelection(DefaultMutableTLTreeNode node) {
        DefaultMutableTLTreeNode parent = (DefaultMutableTLTreeNode)node.getParent();
        int nodeIndex = parent.getIndex((Object)node);
        if (parent.getChildCount() > nodeIndex + 1) {
            return (DefaultMutableTLTreeNode)parent.getChildAt(nodeIndex + 1);
        }
        if (nodeIndex > 0) {
            return (DefaultMutableTLTreeNode)parent.getChildAt(nodeIndex - 1);
        }
        return parent;
    }

    private boolean isAncestor(TLTreeNode<?> possibleAncestor, TLTreeNode<?> node) {
        return this.getAncestors(node).contains(possibleAncestor);
    }

    private List<TLTreeNode<?>> getAncestors(TLTreeNode<?> node) {
        ArrayList ancestorList = new ArrayList();
        for (TLTreeNode ancestor = node.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            ancestorList.add(ancestor);
        }
        return ancestorList;
    }

    private Maybe<TLTreeNode<?>> findNodeWithBusinessObject(Object businessObject) {
        DescendantDFSIterator iterator = new DescendantDFSIterator((TreeView)this.getTreeModel(), (Object)((DefaultMutableTLTreeNode)this.getTreeModel().getRoot()));
        return this.findNodeWithBusinessObject(businessObject, (Iterator<?>)iterator);
    }

    private Maybe<TLTreeNode<?>> findNodeWithBusinessObject(Object businessObject, Iterator<?> treeNodeIterator) {
        while (treeNodeIterator.hasNext()) {
            TLTreeNode node = (TLTreeNode)treeNodeIterator.next();
            if (node.getBusinessObject() != businessObject) continue;
            return Maybe.some((Object)node);
        }
        return Maybe.none();
    }

    private DefaultMutableTLTreeNode getRoot() {
        return (DefaultMutableTLTreeNode)this.getTreeModel().getRoot();
    }

    private MutableTLTreeModel getTreeModel() {
        return (MutableTLTreeModel)this.getTreeUiModel().getWrappedModel();
    }

    private DefaultStructureTreeUIModel getTreeUiModel() {
        return (DefaultStructureTreeUIModel)this.getUIModel().getTreeModel();
    }

    public void linkChannels(Log log) {
        super.linkChannels(log);
        this.selectionChannel().addListener((sender, oldValue, newValue) -> ((ScriptRecorderTree)sender.getComponent()).onSelectionChange(newValue));
    }

    private void onSelectionChange(Object newValue) {
        SelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            this.expandPathToNode((TLTreeNode)newValue);
            Set<Object> selection = newValue == null ? Collections.emptySet() : Collections.singleton(newValue);
            selectionModel.setSelection(selection);
        }
    }

    protected void becomingInvisible() {
        this.stopRecording();
        super.becomingInvisible();
    }

    public static final class Start
    extends AbstractSystemCommand {
        private final Config _config;

        public Start(InstantiationContext context, Config config) {
            super(context, (AbstractSystemCommand.Config)config);
            this._config = config;
        }

        public HandlerResult handleCommand(DisplayContext displayContext, LayoutComponent component, Object model, Map<String, Object> arguments) {
            ScriptRecorderTree tree = (ScriptRecorderTree)component;
            if (tree.isRecording()) {
                tree.stopRecording();
            } else {
                tree.startRecording();
            }
            ResKey labelKey = tree.isRecording() ? this._config.getPauseLabel() : this.getResourceKey(component);
            String label = displayContext.getResources().getString(labelKey);
            CommandModel commandModel = this.getCommandModel(arguments);
            commandModel.setLabel(label);
            commandModel.setTooltip(TagUtil.encodeXML((String)label));
            commandModel.setImage(tree.isRecording() ? this._config.getPauseImage() : this.getImage(component));
            return HandlerResult.DEFAULT_RESULT;
        }

        public static interface Config
        extends AbstractSystemCommand.Config {
            public ThemeImage getPauseImage();

            public ResKey getPauseLabel();
        }
    }

    public static final class RootSelectionDisabled
    implements ExecutabilityRule {
        private final ResKey _error;

        public RootSelectionDisabled(ResKey error) {
            this._error = error;
        }

        public ExecutableState isExecutable(LayoutComponent aComponent, Object model, Map<String, Object> someValues) {
            ScriptRecorderTree selectable = (ScriptRecorderTree)aComponent;
            if (selectable.isRootSelected()) {
                return ExecutableState.createDisabledState((ResKey)this._error);
            }
            return ExecutableState.EXECUTABLE;
        }
    }

    public static final class DerivedSelectionDisabled
    implements ExecutabilityRule {
        public static final ExecutabilityRule INSTANCE = CombinedExecutabilityRule.combine((ExecutabilityRule)NoSelectionDisabled.INSTANCE, (ExecutabilityRule)new DerivedSelectionDisabled());

        private DerivedSelectionDisabled() {
        }

        public ExecutableState isExecutable(LayoutComponent aComponent, Object model, Map<String, Object> someValues) {
            Selectable selectable = (Selectable)aComponent;
            TLTreeNode selection = (TLTreeNode)selectable.getSelected();
            if (selection == null) {
                return ExecutableState.NO_EXEC_NO_MODEL;
            }
            if (ScriptRecorderTree.isDerived(selection)) {
                return ExecutableState.createDisabledState((ResKey)I18NConstants.ERROR_DERIVED_NODE_CANNOT_BE_EDITED);
            }
            return ExecutableState.EXECUTABLE;
        }
    }

    public static final class Group
    extends AbstractSystemCommand {
        public Group(InstantiationContext context, AbstractSystemCommand.Config config) {
            super(context, config);
        }

        public HandlerResult handleCommand(DisplayContext displayContext, LayoutComponent component, Object model, Map<String, Object> arguments) {
            ScriptRecorderTree tree = (ScriptRecorderTree)component;
            if (tree.isNothingSelected()) {
                return HandlerResult.error((ResKey)I18NConstants.ERROR_NO_ACTION_SELECTED);
            }
            if (tree.isRootSelected()) {
                return HandlerResult.error((ResKey)I18NConstants.ERROR_CANNOT_GROUP_ROOT);
            }
            DefaultMutableTLTreeNode selectedNode = tree.getSelectedNode();
            DefaultMutableTLTreeNode parent = (DefaultMutableTLTreeNode)selectedNode.getParent();
            int groupIndex = parent.getIndex((Object)selectedNode);
            ActionChain newChain = ActionFactory.actionChain((ApplicationAction[])new ApplicationAction[0]);
            DefaultMutableTLTreeNode newParentNode = tree.createNode(parent, IndexPosition.before((int)groupIndex), (ApplicationAction)newChain);
            List<ApplicationAction> parentActions = ScriptRecorderTree.actions(parent);
            List newActions = newChain.getActions();
            int indexAfterGroup = groupIndex + 1;
            while (parent.getChildCount() > indexAfterGroup) {
                DefaultMutableTLTreeNode movedNode = (DefaultMutableTLTreeNode)parent.getChildAt(indexAfterGroup);
                movedNode.moveTo((AbstractMutableTLTreeNode)newParentNode);
                ApplicationAction movedAction = parentActions.remove(indexAfterGroup);
                newActions.add(movedAction);
                assert (movedAction == ScriptRecorderTree.action(movedNode));
            }
            tree.getTreeUiModel().setExpanded((Object)newParentNode, true);
            return HandlerResult.DEFAULT_RESULT;
        }

        public ExecutabilityRule createExecutabilityRule() {
            return CombinedExecutabilityRule.combine((ExecutabilityRule)DerivedSelectionDisabled.INSTANCE, (ExecutabilityRule)new RootSelectionDisabled(I18NConstants.ERROR_CANNOT_GROUP_ROOT));
        }
    }

    public static final class UnGroup
    extends AbstractSystemCommand {
        public UnGroup(InstantiationContext context, AbstractSystemCommand.Config config) {
            super(context, config);
        }

        public HandlerResult handleCommand(DisplayContext displayContext, LayoutComponent component, Object model, Map<String, Object> arguments) {
            ScriptRecorderTree tree = (ScriptRecorderTree)component;
            if (tree.isNothingSelected()) {
                return HandlerResult.error((ResKey)I18NConstants.ERROR_NO_ACTION_SELECTED);
            }
            if (tree.isRootSelected()) {
                return HandlerResult.error((ResKey)I18NConstants.ERROR_CANNOT_UNGROUP_ROOT);
            }
            DefaultMutableTLTreeNode selectedNode = tree.getSelectedNode();
            DefaultMutableTLTreeNode parent = (DefaultMutableTLTreeNode)selectedNode.getParent();
            DefaultMutableTLTreeNode grandParent = (DefaultMutableTLTreeNode)parent.getParent();
            if (grandParent == null) {
                return HandlerResult.error((ResKey)I18NConstants.ERROR_CANNOT_UNGROUP_TOPLEVEL_NODE);
            }
            int selectedNodeIndex = parent.getIndex((Object)selectedNode);
            int parentIndex = grandParent.getIndex((Object)parent);
            List<ApplicationAction> parentActions = ScriptRecorderTree.actions(parent);
            List<ApplicationAction> grandParentActions = ScriptRecorderTree.actions(grandParent);
            int i = 0;
            while (parent.getChildCount() > selectedNodeIndex) {
                DefaultMutableTLTreeNode movedNode = (DefaultMutableTLTreeNode)parent.getChildAt(selectedNodeIndex);
                int grandParentIndex = parentIndex + 1 + i;
                movedNode.moveTo((AbstractMutableTLTreeNode)grandParent, grandParentIndex);
                ApplicationAction movedAction = parentActions.remove(selectedNodeIndex);
                grandParentActions.add(grandParentIndex, movedAction);
                assert (movedAction == ScriptRecorderTree.action(movedNode));
                ++i;
            }
            if (parent.getChildren().isEmpty()) {
                tree.deleteNode(parent);
            }
            return HandlerResult.DEFAULT_RESULT;
        }

        public ExecutabilityRule createExecutabilityRule() {
            return CombinedExecutabilityRule.combine((ExecutabilityRule)DerivedSelectionDisabled.INSTANCE, (ExecutabilityRule)new ExecutabilityRule(){

                public ExecutableState isExecutable(LayoutComponent component, Object model, Map<String, Object> someValues) {
                    ScriptRecorderTree tree = (ScriptRecorderTree)component;
                    DefaultMutableTLTreeNode selectedNode = tree.getSelectedNode();
                    if (selectedNode == null) {
                        return ExecutableState.createDisabledState((ResKey)I18NConstants.ERROR_NO_ACTION_SELECTED);
                    }
                    DefaultMutableTLTreeNode parent = (DefaultMutableTLTreeNode)selectedNode.getParent();
                    if (parent == null) {
                        return ExecutableState.createDisabledState((ResKey)I18NConstants.ERROR_CANNOT_UNGROUP_ROOT);
                    }
                    DefaultMutableTLTreeNode grandParent = (DefaultMutableTLTreeNode)parent.getParent();
                    if (grandParent == null) {
                        return ExecutableState.createDisabledState((ResKey)I18NConstants.ERROR_CANNOT_UNGROUP_TOPLEVEL_NODE);
                    }
                    return ExecutableState.EXECUTABLE;
                }
            });
        }
    }

    public static final class Paste
    extends AbstractSystemCommand {
        public Paste(InstantiationContext context, AbstractSystemCommand.Config config) {
            super(context, config);
        }

        public HandlerResult handleCommand(DisplayContext displayContext, LayoutComponent component, Object model, Map<String, Object> arguments) {
            ScriptRecorderTree tree = (ScriptRecorderTree)component;
            if (tree.isNothingSelected()) {
                return HandlerResult.error((ResKey)I18NConstants.ERROR_NO_ACTION_SELECTED);
            }
            DefaultMutableTLTreeNode node = (DefaultMutableTLTreeNode)component.get(CLIPBOARD);
            if (node == null) {
                HandlerResult error = new HandlerResult();
                error.addError(I18NConstants.CLIPBOARD_EMPTY);
                return error;
            }
            ApplicationAction clipboardAction = ScriptRecorderTree.action(node);
            ApplicationAction newAction = (ApplicationAction)TypedConfiguration.copy((ConfigurationItem)clipboardAction);
            tree.insertNodeForAction(newAction);
            return HandlerResult.DEFAULT_RESULT;
        }

        public ExecutabilityRule createExecutabilityRule() {
            return CombinedExecutabilityRule.combine((ExecutabilityRule)DerivedSelectionDisabled.INSTANCE, (ExecutabilityRule)new ExecutabilityRule(){

                public ExecutableState isExecutable(LayoutComponent aComponent, Object model, Map<String, Object> someValues) {
                    if (aComponent.get(CLIPBOARD) == null) {
                        return ExecutableState.createDisabledState((ResKey)I18NConstants.CLIPBOARD_EMPTY);
                    }
                    return ExecutableState.EXECUTABLE;
                }
            });
        }
    }

    public static final class Delete
    extends AbstractSystemCommand {
        public Delete(InstantiationContext context, AbstractSystemCommand.Config config) {
            super(context, config);
        }

        public HandlerResult handleCommand(DisplayContext displayContext, LayoutComponent component, Object model, Map<String, Object> arguments) {
            DefaultMutableTLTreeNode node;
            ScriptRecorderTree tree = (ScriptRecorderTree)component;
            if (tree.isNothingSelected()) {
                return HandlerResult.error((ResKey)I18NConstants.ERROR_NO_ACTION_SELECTED);
            }
            if (tree.isRootSelected()) {
                DefaultMutableTLTreeNode root = tree.getRoot();
                node = (DefaultMutableTLTreeNode)root.createChild(null);
                root.removeChild(root.getIndex((Object)node));
                node.setBusinessObject(root.getBusinessObject());
                tree.setAction(root, (ApplicationAction)ActionFactory.actionChain((ApplicationAction[])new ApplicationAction[0]));
            } else {
                node = tree.getSelectedNode();
                tree.deleteNode(node);
                tree.fireModelEvent(model, 1);
            }
            component.set(CLIPBOARD, (Object)node);
            return HandlerResult.DEFAULT_RESULT;
        }

        public ExecutabilityRule createExecutabilityRule() {
            return DerivedSelectionDisabled.INSTANCE;
        }
    }

    public static interface Config
    extends BoundComponent.Config {
        public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
        public static final String TREE_DROP_TARGET = "treeDropTarget";
        public static final String TREE_DRAG_SOURCE = "treeDragSource";

        @ItemDefault(value=ControlRepresentableCP.Config.class)
        public PolymorphicConfiguration<LayoutControlProvider> getComponentControlProvider();

        @Name(value="treeDragSource")
        @ItemDefault(value=DefaultTreeDrag.class)
        public PolymorphicConfiguration<TreeDragSource> getTreeDragSource();

        @Name(value="treeDropTarget")
        @ItemDefault(value=ScriptingRecorderDropTarget.class)
        public PolymorphicConfiguration<TreeDropTarget> getTreeDropTarget();

        default public void modifyIntrinsicCommands(CommandRegistry registry) {
            super.modifyIntrinsicCommands(registry);
            registry.registerButton("expandAll");
            registry.registerButton("collapseAll");
        }
    }
}

