/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.basic.CollectionUtil;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.annotation.defaults.FormattedDefault;
import com.top_logic.basic.io.binary.BinaryData;
import com.top_logic.layout.ModelSpec;
import com.top_logic.layout.basic.ThemeImage;
import com.top_logic.layout.form.model.DataField;
import com.top_logic.layout.scripting.template.gui.I18NConstants;
import com.top_logic.layout.scripting.template.gui.ScriptContainer;
import com.top_logic.layout.scripting.template.gui.ScriptUploadComponent;
import com.top_logic.layout.scripting.template.gui.ScriptingGuiUtil;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.boundsec.CommandGroupReference;
import com.top_logic.tool.boundsec.conditional.CommandStep;
import com.top_logic.tool.boundsec.conditional.Failure;
import com.top_logic.tool.boundsec.conditional.FunctionalSuccess;
import com.top_logic.tool.boundsec.conditional.PreconditionCommandHandler;
import java.util.Map;

public class ScriptUploadCommand
extends PreconditionCommandHandler {
    public ScriptUploadCommand(InstantiationContext context, Config config) {
        super(context, (AbstractCommandHandler.Config)config);
    }

    protected CommandStep prepare(LayoutComponent component, Object model, Map<String, Object> arguments) {
        ScriptContainer scriptContainer;
        ScriptUploadComponent uploadComponent = (ScriptUploadComponent)component;
        DataField field = uploadComponent.getFileUploadField();
        BinaryData binaryData = (BinaryData)CollectionUtil.getSingleValueFrom((Object)field.getValue());
        if (binaryData == null) {
            return new Failure(I18NConstants.UPLOAD_DIALOG_NO_FILE_UPLOADED);
        }
        try {
            scriptContainer = ScriptingGuiUtil.toScriptContainer(binaryData);
        }
        catch (RuntimeException exception) {
            return new Failure(I18NConstants.UPLOAD_DIALOG_SCRIPT_NOT_VALID__ERROR.fill((Object)exception.getMessage()));
        }
        return FunctionalSuccess.toSuccess(ignored -> this.acceptScriptAndCloseDialog(component, scriptContainer));
    }

    private void acceptScriptAndCloseDialog(LayoutComponent component, ScriptContainer scriptContainer) {
        this.setScriptIntoScriptRecorderTree(component, scriptContainer);
        component.closeDialog();
    }

    private boolean setScriptIntoScriptRecorderTree(LayoutComponent component, ScriptContainer scriptContainer) {
        return component.getDialogParent().setModel((Object)scriptContainer);
    }

    public static interface Config
    extends AbstractCommandHandler.Config {
        @FormattedDefault(value="null()")
        public ModelSpec getTarget();

        @FormattedDefault(value="System")
        public CommandGroupReference getGroup();

        @FormattedDefault(value="save")
        public String getClique();

        @FormattedDefault(value="theme:ICONS_IMPORT")
        public ThemeImage getImage();
    }
}

