/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.basic.io.BinaryContent;
import com.top_logic.basic.io.binary.BinaryData;
import com.top_logic.basic.io.binary.BinaryDataFactory;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.runtime.ActionReader;
import com.top_logic.layout.scripting.template.excel.ExcelChecker;
import com.top_logic.layout.scripting.template.excel.ExcelCollector;
import com.top_logic.layout.scripting.template.gui.ScriptContainer;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class ScriptingGuiUtil {
    public static ScriptContainer toScriptContainer(File script) {
        ApplicationAction actions = ScriptingGuiUtil.parse(BinaryDataFactory.createBinaryData((File)script));
        if (script.getName().endsWith(".xml")) {
            return ScriptContainer.createPersistable(actions, script);
        }
        return ScriptContainer.createTransient(actions);
    }

    public static ScriptContainer toScriptContainer(BinaryData script) {
        return ScriptContainer.createTransient(ScriptingGuiUtil.parse(script));
    }

    private static ApplicationAction parse(BinaryData script) {
        if (script.getName().endsWith(".xml")) {
            return ScriptingGuiUtil.parseActions(script);
        }
        if (ExcelChecker.supportsFile(script)) {
            return ScriptingGuiUtil.parseExcel(script);
        }
        throw new IllegalArgumentException("Unknown file typ: " + script.getName());
    }

    private static ApplicationAction parseActions(BinaryData binaryData) {
        try {
            return ActionReader.INSTANCE.readAction((BinaryContent)binaryData);
        }
        catch (ConfigurationException ex) {
            String message = "Failed to parse the actions in the given file: " + ex.getMessage();
            throw new RuntimeException(message, ex);
        }
    }

    private static ApplicationAction parseExcel(BinaryData binaryData) {
        List<ExcelCollector.ExcelSheetConfig> sheetConfigs = Collections.emptyList();
        String excelName = binaryData.getName();
        return new ExcelChecker(excelName, binaryData, ExcelCollector.ExcelFileConfig.BasicSheetSet.FILE_DEFINED, sheetConfigs).get();
    }
}

