/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.basic.UnreachableAssertion;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.PolymorphicConfiguration;
import com.top_logic.basic.util.Utils;
import com.top_logic.layout.IndexPosition;
import com.top_logic.layout.scripting.action.ActionChain;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.template.gui.ScriptRecorderTree;
import com.top_logic.layout.tree.dnd.TreeDropEvent;
import com.top_logic.layout.tree.dnd.TreeDropTarget;
import com.top_logic.layout.tree.model.AbstractMutableTLTreeNode;
import com.top_logic.layout.tree.model.DefaultMutableTLTreeNode;
import com.top_logic.layout.tree.model.TLTreeModelUtil;
import com.top_logic.layout.tree.model.TLTreeNode;
import com.top_logic.mig.html.layout.LayoutComponent;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ScriptingRecorderDropTarget
implements TreeDropTarget {
    private ScriptRecorderTree _scriptRecorderTree;

    public ScriptingRecorderDropTarget(InstantiationContext context, Config config) {
        context.resolveReference((Object)InstantiationContext.OUTER, LayoutComponent.class, this::initScriptRecorderTree);
    }

    private ScriptRecorderTree initScriptRecorderTree(LayoutComponent value) {
        this._scriptRecorderTree = (ScriptRecorderTree)Objects.requireNonNull(value);
        return this._scriptRecorderTree;
    }

    public void handleDrop(TreeDropEvent event) {
        DefaultMutableTLTreeNode target;
        Object droppedObject;
        DefaultMutableTLTreeNode source;
        Iterator iterator = event.getData().iterator();
        while (iterator.hasNext() && !this.isImpossibleMove(source = (DefaultMutableTLTreeNode)(droppedObject = iterator.next()), target = (DefaultMutableTLTreeNode)event.getRefNode())) {
            boolean movedSelected = this.isSelection(source);
            this.removeNodeFromSource(source);
            this.insertNodeAtTarget(event.getPos(), source, target);
            this.updateSelection(source, movedSelected);
        }
    }

    private boolean isImpossibleMove(DefaultMutableTLTreeNode source, DefaultMutableTLTreeNode target) {
        if (Utils.equals((Object)source, (Object)target)) {
            return true;
        }
        if (target.getParent() == null) {
            return true;
        }
        return TLTreeModelUtil.createPathToRoot((TLTreeNode)target).contains(source);
    }

    private boolean isSelection(DefaultMutableTLTreeNode source) {
        return this.getScriptRecorderTree().getTreeData().getSelectionModel().isSelected((Object)source);
    }

    private void removeNodeFromSource(DefaultMutableTLTreeNode source) {
        DefaultMutableTLTreeNode sourceParent = (DefaultMutableTLTreeNode)source.getParent();
        int sourceIndex = sourceParent.getIndex((Object)source);
        List<ApplicationAction> sourceActions = this.getChildActions(sourceParent);
        sourceActions.remove(ScriptRecorderTree.action(source));
        sourceParent.removeChild(sourceIndex);
    }

    private List<ApplicationAction> getChildActions(DefaultMutableTLTreeNode sourceParent) {
        return ((ActionChain)ScriptRecorderTree.action(sourceParent)).getActions();
    }

    private void insertNodeAtTarget(TreeDropEvent.Position position, DefaultMutableTLTreeNode source, DefaultMutableTLTreeNode target) {
        DefaultMutableTLTreeNode targetParent = (DefaultMutableTLTreeNode)target.getParent();
        int targetIndex = targetParent.getIndex((Object)target);
        switch (position) {
            case ABOVE: {
                this.updateTree(targetParent, IndexPosition.before((int)targetIndex), source);
                return;
            }
            case WITHIN: {
                if (ScriptRecorderTree.action(target) instanceof ActionChain) {
                    this.updateTree(target, IndexPosition.before((int)0), source);
                } else {
                    this.updateTree(targetParent, IndexPosition.after((int)targetIndex), source);
                }
                return;
            }
            case BELOW: {
                this.updateTree(targetParent, IndexPosition.after((int)targetIndex), source);
                return;
            }
        }
        throw new UnreachableAssertion("Unexpected position: " + position);
    }

    private void updateTree(DefaultMutableTLTreeNode newParent, IndexPosition insertPosition, DefaultMutableTLTreeNode draggedNode) {
        newParent.addChild(insertPosition, (AbstractMutableTLTreeNode)draggedNode);
        ApplicationAction draggedAction = ScriptRecorderTree.action(draggedNode);
        this.getScriptRecorderTree().updateActionChain(newParent, insertPosition, draggedAction, draggedNode);
    }

    private void updateSelection(DefaultMutableTLTreeNode source, boolean movedSelected) {
        if (movedSelected) {
            this.getScriptRecorderTree().getTreeData().getSelectionModel().setSelected((Object)source, true);
        }
    }

    private ScriptRecorderTree getScriptRecorderTree() {
        return this._scriptRecorderTree;
    }

    public static interface Config
    extends PolymorphicConfiguration<ScriptingRecorderDropTarget> {
    }
}

