/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.base.context.TLSubSessionContext;
import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.knowledge.wrap.person.Person;
import com.top_logic.layout.DisplayContext;
import com.top_logic.layout.basic.DefaultDisplayContext;
import com.top_logic.layout.scripting.runtime.action.ApplicationAssertions;
import com.top_logic.layout.scripting.runtime.execution.LiveActionExecutor;
import com.top_logic.layout.scripting.runtime.execution.ScriptController;
import com.top_logic.layout.scripting.template.gui.ApplyApplicationAction;
import com.top_logic.layout.scripting.template.gui.MultiUserScriptController;
import com.top_logic.layout.scripting.template.gui.ScriptRecorderTree;
import com.top_logic.layout.tree.model.TLTreeNode;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.boundsec.HandlerResult;
import com.top_logic.util.TLContextManager;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StartBackgroundReplayCommand
extends AbstractCommandHandler {
    public StartBackgroundReplayCommand(InstantiationContext context, AbstractCommandHandler.Config config) {
        super(context, config);
    }

    public HandlerResult handleCommand(DisplayContext context, LayoutComponent component, Object model, Map<String, Object> arguments) {
        final ScriptRecorderTree scriptRecorder = (ScriptRecorderTree)component;
        TLTreeNode selection = (TLTreeNode)scriptRecorder.getTreeData().getTreeModel().getRoot();
        String sessionUser = TLContextManager.getCurrentUserName((TLSubSessionContext)context.getSubSessionContext());
        final MultiUserScriptController controller = new MultiUserScriptController(sessionUser, selection);
        if (controller.hasNext()) {
            ApplyApplicationAction.setCurrentExecution((LayoutComponent)scriptRecorder, (ScriptController)controller);
            String userId = controller.currentUser();
            if (!userId.equals(sessionUser)) {
                controller.stop();
                ApplyApplicationAction.stopExecution((LayoutComponent)scriptRecorder);
                throw ApplicationAssertions.fail((ConfigurationItem)controller.currentOfAnyUser(), (String)("Script user '" + userId + "' does not match current user '" + sessionUser + "', an explicit login action is required."));
            }
            Person user = context.getSubSessionContext().getPerson();
            LiveActionExecutor.startSession((DisplayContext)context, (ScriptController)controller, (String)userId, (Person)user, (boolean)true);
            Runnable update = new Runnable(){

                @Override
                public void run() {
                    TLTreeNode current = controller.scriptPosition();
                    TLTreeNode lastNode = current == null ? scriptRecorder.getTreeData().getTreeModel().getRoot() : current;
                    scriptRecorder.setSelected(lastNode);
                    if (controller.isStopped()) {
                        ApplyApplicationAction.stopExecution((LayoutComponent)scriptRecorder);
                    } else {
                        StartBackgroundReplayCommand.this.schedule(this);
                    }
                }
            };
            this.schedule(update);
        }
        return HandlerResult.DEFAULT_RESULT;
    }

    void schedule(Runnable update) {
        DisplayContext context = DefaultDisplayContext.getDisplayContext();
        ScheduledExecutorService executor = context.getLayoutContext().getMainLayout().getWindowScope().getUIExecutor();
        executor.schedule(update, 2L, TimeUnit.SECONDS);
    }
}

