/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui;

import com.top_logic.basic.StringServices;
import com.top_logic.basic.col.TypedAnnotatable;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.TypedConfiguration;
import com.top_logic.layout.DisplayContext;
import com.top_logic.layout.DisplayDimension;
import com.top_logic.layout.DisplayUnit;
import com.top_logic.layout.basic.Command;
import com.top_logic.layout.basic.CommandModel;
import com.top_logic.layout.form.CheckException;
import com.top_logic.layout.form.Constraint;
import com.top_logic.layout.form.FormMember;
import com.top_logic.layout.form.component.AbstractApplyCommandHandler;
import com.top_logic.layout.form.constraints.AbstractConstraint;
import com.top_logic.layout.form.model.FormContext;
import com.top_logic.layout.form.model.FormFactory;
import com.top_logic.layout.form.model.StringField;
import com.top_logic.layout.messagebox.MessageBox;
import com.top_logic.layout.messagebox.SimpleFormDialog;
import com.top_logic.layout.scripting.action.ActionFactory;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.action.SetGlobalVariableAction;
import com.top_logic.layout.scripting.recorder.ScriptingRecorder;
import com.top_logic.layout.scripting.recorder.ref.LastRevisionNamingScheme;
import com.top_logic.layout.scripting.recorder.ref.ModelName;
import com.top_logic.layout.scripting.runtime.GlobalVariableStore;
import com.top_logic.layout.scripting.template.gui.EnabledDuringRecording;
import com.top_logic.layout.scripting.template.gui.I18NConstants;
import com.top_logic.layout.scripting.template.gui.ScriptRecorderTree;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.boundsec.HandlerResult;
import com.top_logic.tool.execution.ExecutabilityRule;
import com.top_logic.util.Resources;
import java.util.List;
import java.util.Map;

public class StoreCurrentRevisionCommand
extends AbstractCommandHandler {
    public StoreCurrentRevisionCommand(InstantiationContext context, AbstractCommandHandler.Config config) {
        super(context, config);
    }

    public HandlerResult handleCommand(DisplayContext aContext, LayoutComponent aComponent, Object model, Map<String, Object> someArguments) {
        return new VariableNameDialog((ScriptRecorderTree)aComponent).open(aContext);
    }

    public ExecutabilityRule createExecutabilityRule() {
        return EnabledDuringRecording.INSTANCE;
    }

    static class VariableNameDialog
    extends SimpleFormDialog {
        final ScriptRecorderTree _scriptRecorderTree;

        public VariableNameDialog(ScriptRecorderTree scriptRecorder) {
            super(I18NConstants.VARIABLE_NAME_DIALOG, DisplayDimension.dim((float)330.0f, (DisplayUnit)DisplayUnit.PIXEL), DisplayDimension.dim((float)150.0f, (DisplayUnit)DisplayUnit.PIXEL));
            this._scriptRecorderTree = scriptRecorder;
        }

        protected void fillButtons(List<CommandModel> buttons) {
            StoreCommand command = new StoreCommand();
            CommandModel ok = MessageBox.button((MessageBox.ButtonType)MessageBox.ButtonType.OK, (Command)command);
            ScriptingRecorder.annotateAsDontRecord((TypedAnnotatable)ok);
            buttons.add(ok);
            CommandModel cancel = MessageBox.button((MessageBox.ButtonType)MessageBox.ButtonType.CANCEL, (Command)this.getDiscardClosure());
            ScriptingRecorder.annotateAsDontRecord((TypedAnnotatable)cancel);
            buttons.add(cancel);
        }

        protected void fillFormContext(FormContext context) {
            StringField newStringField = FormFactory.newStringField((String)"input");
            newStringField.setMandatory(true);
            newStringField.addConstraint((Constraint)new AbstractConstraint(){
                private static final String VARIABLE_EXISTS_SUFFIX = "variableExists";

                public boolean check(Object value) throws CheckException {
                    boolean variableExists = GlobalVariableStore.getElseCreateFromSession().has(StringServices.nonNull((String)((String)value)));
                    if (variableExists) {
                        throw new CheckException(Resources.getInstance().getMessage(I18NConstants.VARIABLE_NAME_DIALOG.key(VARIABLE_EXISTS_SUFFIX), new Object[]{value}));
                    }
                    return true;
                }
            });
            context.addMember((FormMember)newStringField);
            ScriptingRecorder.annotateAsDontRecord((TypedAnnotatable)context);
        }

        final class StoreCommand
        implements Command {
            StoreCommand() {
            }

            public HandlerResult executeCommand(DisplayContext context) {
                FormContext formContext = VariableNameDialog.this.getFormContext();
                boolean checkAll = formContext.checkAll();
                if (!checkAll) {
                    return AbstractApplyCommandHandler.createErrorResult((FormContext)formContext);
                }
                String variableName = ((StringField)formContext.getField("input")).getAsString();
                this.resordSetLastRevision(variableName);
                return VariableNameDialog.this.getDialogModel().getCloseAction().executeCommand(context);
            }

            private void resordSetLastRevision(String variableName) {
                ModelName lastRevisionName = (ModelName)TypedConfiguration.newConfigItem(LastRevisionNamingScheme.Name.class);
                SetGlobalVariableAction action = ActionFactory.setGlobalVariableAction((String)variableName, (ModelName)lastRevisionName);
                VariableNameDialog.this._scriptRecorderTree.insertAction((ApplicationAction)action);
            }
        }
    }
}

