/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.saveas;

import com.google.common.io.Files;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.annotation.defaults.FormattedDefault;
import com.top_logic.basic.config.annotation.defaults.StringDefault;
import com.top_logic.layout.DisplayContext;
import com.top_logic.layout.DisplayDimension;
import com.top_logic.layout.ModelSpec;
import com.top_logic.layout.basic.CommandModel;
import com.top_logic.layout.basic.ThemeImage;
import com.top_logic.layout.form.FormHandler;
import com.top_logic.layout.form.component.AbstractApplyCommandHandler;
import com.top_logic.layout.form.model.FormContext;
import com.top_logic.layout.messagebox.MessageBox;
import com.top_logic.layout.scripting.action.ApplicationAction;
import com.top_logic.layout.scripting.recorder.ActionWriter;
import com.top_logic.layout.scripting.template.gui.ScriptContainer;
import com.top_logic.layout.scripting.template.gui.saveas.I18NConstants;
import com.top_logic.layout.structure.DefaultLayoutData;
import com.top_logic.layout.structure.LayoutData;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.boundsec.CommandGroupReference;
import com.top_logic.tool.boundsec.HandlerResult;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class SaveScriptAsCommand
extends AbstractCommandHandler {
    public SaveScriptAsCommand(InstantiationContext context, Config config) {
        super(context, (AbstractCommandHandler.Config)config);
    }

    public HandlerResult handleCommand(DisplayContext context, LayoutComponent component, Object model, Map<String, Object> arguments) {
        HandlerResult result = this.checkForm(component);
        if (result != null) {
            return result;
        }
        File file = (File)model;
        if (file.exists()) {
            LayoutData layout = DefaultLayoutData.newLayoutData((DisplayDimension)DisplayDimension.px((float)400.0f), (DisplayDimension)DisplayDimension.px((float)150.0f));
            CommandModel ok = MessageBox.button((MessageBox.ButtonType)MessageBox.ButtonType.OK, approveContext -> this.saveAndCloseDialog(component, file));
            CommandModel cancelButton = MessageBox.button((MessageBox.ButtonType)MessageBox.ButtonType.CANCEL);
            return MessageBox.newBuilder((MessageBox.MessageType)MessageBox.MessageType.CONFIRM).layout(layout).message(I18NConstants.CONFIRM_OVERWRITE_FILE__NAME.fill((Object)file.getName())).buttons(new CommandModel[]{ok, cancelButton}).confirm(context.getWindowScope());
        }
        return this.saveAndCloseDialog(component, file);
    }

    private HandlerResult checkForm(LayoutComponent component) {
        FormHandler formHandler;
        if (component instanceof FormHandler && !(formHandler = (FormHandler)component).getFormContext().checkAll()) {
            return AbstractApplyCommandHandler.createErrorResult((FormContext)formHandler.getFormContext());
        }
        return null;
    }

    private HandlerResult saveAndCloseDialog(LayoutComponent component, File file) {
        this.saveScript(component, file);
        component.closeDialog();
        return HandlerResult.DEFAULT_RESULT;
    }

    private void saveScript(LayoutComponent component, File file) {
        ScriptContainer scriptContainer = (ScriptContainer)this.getScriptRecorderTree(component).getModel();
        ApplicationAction action = scriptContainer.getAction();
        this.writeActionToFile(file, action);
        ScriptContainer.PersistableScriptContainer newScriptContainer = ScriptContainer.createPersistable(scriptContainer.getAction(), file);
        this.getScriptRecorderTree(component).setModel((Object)newScriptContainer);
    }

    private LayoutComponent getScriptRecorderTree(LayoutComponent component) {
        return component.getDialogParent();
    }

    private void writeActionToFile(File file, ApplicationAction action) {
        String actionXml = ActionWriter.INSTANCE.writeAction(action, true, true);
        this.writeToFile(file, actionXml);
    }

    private void writeToFile(File file, String text) {
        try {
            Files.write((CharSequence)text, (File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static interface Config
    extends AbstractCommandHandler.Config {
        @StringDefault(value="create")
        public String getClique();

        @FormattedDefault(value="System")
        public CommandGroupReference getGroup();

        @FormattedDefault(value="theme:ICONS_BUTTON_OK")
        public ThemeImage getImage();

        @FormattedDefault(value="selection(self())")
        public ModelSpec getTarget();
    }
}

