/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.saveas;

import com.top_logic.basic.CollectionUtil;
import com.top_logic.basic.config.AbstractConfiguredInstance;
import com.top_logic.basic.config.CommaSeparatedStrings;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.PolymorphicConfiguration;
import com.top_logic.basic.config.annotation.Format;
import com.top_logic.basic.config.annotation.Name;
import com.top_logic.knowledge.gui.layout.upload.ModularFileNameConstraint;
import com.top_logic.layout.form.Constraint;
import com.top_logic.layout.form.FormMember;
import com.top_logic.layout.form.ValueListener;
import com.top_logic.layout.form.component.SelectableFormComponent;
import com.top_logic.layout.form.model.FormContext;
import com.top_logic.layout.form.model.FormFactory;
import com.top_logic.layout.form.model.StringField;
import com.top_logic.mig.html.ModelBuilder;
import com.top_logic.mig.html.layout.LayoutComponent;
import java.io.File;
import java.util.List;

public class SaveScriptAsFormBuilder<C extends Config<?>>
extends AbstractConfiguredInstance<C>
implements ModelBuilder {
    public static final String FIELD_FILE_NAME = "file-name";
    private final List<String> _allowedEndings;

    public SaveScriptAsFormBuilder(InstantiationContext context, C config) {
        super(context, config);
        this._allowedEndings = config.getAllowedEndings();
    }

    public Object getModel(Object businessModel, LayoutComponent component) {
        return this.createFormContext((SelectableFormComponent)component, (File)businessModel);
    }

    private Object createFormContext(SelectableFormComponent formComponent, File selectedFileOrFolder) {
        FormContext formContext = new FormContext((LayoutComponent)formComponent);
        formContext.addMember((FormMember)this.createFileNameField(formComponent, selectedFileOrFolder));
        return formContext;
    }

    private StringField createFileNameField(SelectableFormComponent formComponent, File selectedFileOrFolder) {
        StringField fileNameField = FormFactory.newStringField((String)FIELD_FILE_NAME);
        if (!selectedFileOrFolder.isDirectory()) {
            fileNameField.initializeField((Object)selectedFileOrFolder.getName());
            formComponent.setSelected((Object)selectedFileOrFolder);
        }
        fileNameField.setMandatory(true);
        this.addFileNameConstraint(fileNameField);
        fileNameField.addValueListener(this.getFileNameFieldListener(formComponent));
        return fileNameField;
    }

    private void addFileNameConstraint(StringField field) {
        if (!CollectionUtil.isEmptyOrNull(this._allowedEndings)) {
            field.addConstraint((Constraint)new ModularFileNameConstraint(this._allowedEndings));
        }
    }

    private ValueListener getFileNameFieldListener(SelectableFormComponent component) {
        return (field, oldValue, newValue) -> this.onFileNameInput(component, (String)newValue);
    }

    private boolean onFileNameInput(SelectableFormComponent component, String fileName) {
        File folderViewSelection = (File)component.getModel();
        return component.setSelected((Object)this.getSelectedFile(folderViewSelection, fileName));
    }

    private File getSelectedFile(File selectedFileOrFolder, String fileName) {
        if (selectedFileOrFolder.isDirectory()) {
            return new File(selectedFileOrFolder, fileName);
        }
        File currentDirectory = selectedFileOrFolder.getParentFile();
        return new File(currentDirectory, fileName);
    }

    public boolean supportsModel(Object model, LayoutComponent component) {
        return model instanceof File;
    }

    public static interface Config<T extends SaveScriptAsFormBuilder<?>>
    extends PolymorphicConfiguration<T> {
        public static final String ALLOWED_ENDINGS = "allowedEndings";

        @Name(value="allowedEndings")
        @Format(value=CommaSeparatedStrings.class)
        public List<String> getAllowedEndings();
    }
}

