/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.selector;

import com.top_logic.basic.util.ResKey;
import com.top_logic.layout.WindowScope;
import com.top_logic.layout.basic.CommandModel;
import com.top_logic.layout.channel.ComponentChannel;
import com.top_logic.layout.messagebox.MessageBox;
import com.top_logic.layout.scripting.template.gui.I18NConstants;
import com.top_logic.layout.scripting.template.gui.ScriptContainer;
import com.top_logic.layout.scripting.template.gui.ScriptingGuiUtil;
import com.top_logic.layout.scripting.template.gui.selector.ScriptSelectorComponent;
import com.top_logic.util.Resources;
import java.io.File;

final class AcceptSelectedScriptListener
implements ComponentChannel.ChannelListener {
    public static final AcceptSelectedScriptListener INSTANCE = new AcceptSelectedScriptListener();

    AcceptSelectedScriptListener() {
    }

    public void handleNewValue(ComponentChannel sender, Object oldSelection, Object newSelection) {
        if (newSelection == null) {
            return;
        }
        File selectedFile = (File)newSelection;
        if (selectedFile.isDirectory()) {
            return;
        }
        ScriptSelectorComponent selectorComponent = (ScriptSelectorComponent)sender.getComponent();
        ScriptContainer scriptContainer = this.createScriptContainer(selectorComponent, selectedFile);
        if (scriptContainer == null) {
            return;
        }
        selectorComponent.getDialogParent().setModel((Object)scriptContainer);
        selectorComponent.closeDialog();
    }

    private ScriptContainer createScriptContainer(ScriptSelectorComponent selectorComponent, File selectedFile) {
        try {
            return ScriptingGuiUtil.toScriptContainer(selectedFile);
        }
        catch (Exception ex) {
            String title = this.translate(I18NConstants.FAILED_TO_PARSE_SCRIPTED_TEST_TITLE);
            String message = this.translate(I18NConstants.FAILED_TO_PARSE_SCRIPTED_TEST__FILE_ERROR.fill((Object)selectedFile.getName(), (Object)ex.getMessage()));
            CommandModel okButton = MessageBox.button((MessageBox.ButtonType)MessageBox.ButtonType.OK);
            MessageBox.confirm((WindowScope)selectorComponent.getWindowScope(), (MessageBox.MessageType)MessageBox.MessageType.ERROR, (String)title, (String)message, (CommandModel[])new CommandModel[]{okButton});
            selectorComponent.getTableSelectionModel().clear();
            return null;
        }
    }

    private String translate(ResKey i18nKey) {
        return Resources.getInstance().getString(i18nKey);
    }
}

