/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.col.TypedAnnotatable;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.layout.DisplayContext;
import com.top_logic.layout.basic.Command;
import com.top_logic.layout.basic.CommandModel;
import com.top_logic.layout.component.Selectable;
import com.top_logic.layout.messagebox.MessageBox;
import com.top_logic.layout.scripting.recorder.ScriptingRecorder;
import com.top_logic.layout.scripting.template.gui.templates.I18NConstants;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateResource;
import com.top_logic.layout.tree.model.TLTreeNode;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.boundsec.HandlerResult;
import com.top_logic.util.error.TopLogicException;
import java.io.IOException;
import java.util.Map;

public class DeleteTemplateCommand
extends AbstractCommandHandler {
    public DeleteTemplateCommand(InstantiationContext context, AbstractCommandHandler.Config config) {
        super(context, config);
    }

    public HandlerResult handleCommand(DisplayContext aContext, final LayoutComponent component, Object model, Map<String, Object> someArguments) {
        Selectable selectable = (Selectable)component;
        TLTreeNode node = (TLTreeNode)selectable.getSelected();
        final TemplateResource templateResource = (TemplateResource)node.getBusinessObject();
        Command delete = new Command(){

            public HandlerResult executeCommand(DisplayContext context) {
                try {
                    templateResource.delete();
                    component.fireModelDeletedEvent((Object)templateResource, (Object)component.getMainLayout());
                }
                catch (IOException ex) {
                    throw new TopLogicException(I18NConstants.ERROR_TEMPLATE_DELETING_FAILED__NAME_ERROR.fill((Object)templateResource.getResourceSuffix(), (Object)ex.getMessage()), (Throwable)ex);
                }
                return HandlerResult.DEFAULT_RESULT;
            }
        };
        return MessageBox.confirm((DisplayContext)aContext, (MessageBox.MessageType)MessageBox.MessageType.CONFIRM, (String)aContext.getResources().getString(I18NConstants.REALLY_DELETE__NAME.fill((Object)templateResource.getName())), (CommandModel[])new CommandModel[]{this.dontRecord(MessageBox.button((MessageBox.ButtonType)MessageBox.ButtonType.YES, (Command)delete)), this.dontRecord(MessageBox.button((MessageBox.ButtonType)MessageBox.ButtonType.NO))});
    }

    private CommandModel dontRecord(CommandModel button) {
        ScriptingRecorder.annotateAsDontRecord((TypedAnnotatable)button);
        return button;
    }
}

