/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.FileManager;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.io.FileUtilities;
import com.top_logic.layout.scripting.template.gui.templates.TemplateTreeComponent;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.export.AbstractZipDownloadHandler;
import com.top_logic.util.Zipper;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public abstract class DownloadScriptRecorderTemplateFoldersHandler
extends AbstractZipDownloadHandler {
    protected static final String SCRIPT_TEMPLATE_ZIP_PREFIX_FILENAME = "script-template";

    public DownloadScriptRecorderTemplateFoldersHandler(InstantiationContext context, AbstractCommandHandler.Config config) {
        super(context, config);
    }

    private void zipFile(Zipper zipper, String resourcePath, String name) throws FileNotFoundException, IOException {
        FileManager fileManager = FileManager.getInstance();
        if (fileManager.isDirectory(resourcePath)) {
            zipper.addFolderByResourcePath(resourcePath, name);
        } else {
            zipper.addFile(fileManager.getStream(resourcePath), name);
        }
    }

    protected void addFilesToZip(Zipper zipper, LayoutComponent component, Map<String, Object> arguments) {
        TemplateTreeComponent templateTreeComponent = this.getTemplateTreeComponent(component);
        for (String resourcePathToZip : this.getToZippedTemplateFolderPaths(templateTreeComponent)) {
            this.zipFiles(zipper, resourcePathToZip, FileUtilities.getFilenameOfResource((String)resourcePathToZip));
        }
    }

    private void zipFiles(Zipper zipper, String resourcePath, String name) {
        try {
            this.zipFile(zipper, resourcePath, name);
        }
        catch (IOException exception) {
            throw new IOError(exception);
        }
    }

    private TemplateTreeComponent getTemplateTreeComponent(LayoutComponent component) {
        return (TemplateTreeComponent)component;
    }

    protected abstract Collection<String> getToZippedTemplateFolderPaths(TemplateTreeComponent var1);
}

