/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.io.FileUtilities;
import com.top_logic.basic.io.binary.BinaryData;
import com.top_logic.basic.tooling.Workspace;
import com.top_logic.layout.scripting.template.gui.templates.ScriptTemplateUtil;
import com.top_logic.layout.scripting.template.gui.templates.TemplateTreeComponent;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateFolder;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateLocation;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateResource;
import com.top_logic.layout.tree.model.AbstractMutableTLTreeNode;
import com.top_logic.layout.tree.model.DefaultMutableTLTreeNode;
import com.top_logic.layout.tree.model.StructureTreeModel;
import com.top_logic.layout.tree.model.TLTreeNode;
import com.top_logic.tool.dataImport.ImportZipDataCommand;
import com.top_logic.tool.dataImport.UploadDataDialog;
import com.top_logic.tool.dataImport.ZipImporter;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ImportScriptRecorderTemplateCommand
extends ImportZipDataCommand {
    protected static final String ZIP_COMPRESSED_CONTENT_TYPE = "application/x-zip-compressed";
    private final TemplateTreeComponent _templateComponent;

    public ImportScriptRecorderTemplateCommand(UploadDataDialog uploadDialog, TemplateTreeComponent templateComponent) {
        super(uploadDialog);
        this._templateComponent = Objects.requireNonNull(templateComponent);
    }

    protected void uploadPostProcess(BinaryData data) {
        if (ZIP_COMPRESSED_CONTENT_TYPE.equals(data.getContentType())) {
            super.uploadPostProcess(data);
            this._templateComponent.resetTreeModel();
        } else {
            TLTreeNode<?> child = this.createTemplateNode(data);
            this._templateComponent.resetTreeModel();
            this._templateComponent.setSelected(child);
        }
    }

    private TLTreeNode<?> createTemplateNode(BinaryData data) throws IOError {
        TemplateResource importSingleTemplateFile = this.importSingleTemplateFile(data);
        return this.createTemplateNode(importSingleTemplateFile, ScriptTemplateUtil.getSelectedNode(this._templateComponent));
    }

    private TLTreeNode<?> createTemplateNode(TemplateResource newTemplate, StructureTreeModel.Node rootNodeToImportTo) {
        AbstractMutableTLTreeNode newTemplateResourceNode = rootNodeToImportTo.isLeaf() ? ((DefaultMutableTLTreeNode)rootNodeToImportTo.getParent()).createChild((Object)newTemplate) : rootNodeToImportTo.createChild((Object)newTemplate);
        newTemplate.initLocation((TLTreeNode<?>)newTemplateResourceNode);
        return newTemplateResourceNode;
    }

    private TemplateResource importSingleTemplateFile(BinaryData data) throws IOError {
        try {
            String pathSuffixToTemplateRoot = this.createResourceSuffixToTemplateRoot(data.getName());
            File newTemplateFile = new File(Workspace.topLevelWebapp(), this.getResourcePath(pathSuffixToTemplateRoot));
            newTemplateFile.getParentFile().mkdirs();
            if (newTemplateFile.createNewFile()) {
                this.writeSingleTemplateFile(data, newTemplateFile);
            }
            return new TemplateResource(pathSuffixToTemplateRoot);
        }
        catch (IOException exception) {
            throw new IOError(exception);
        }
    }

    String getResourcePath(String pathSuffixToTemplateRoot) {
        return ScriptTemplateUtil.getTemplateRootPath(this._templateComponent) + pathSuffixToTemplateRoot;
    }

    String createResourceSuffixToTemplateRoot(String name) {
        return this.getSelectedContainingTemplateFolderResourceSuffix() + name;
    }

    private void writeSingleTemplateFile(BinaryData data, File templateFile) throws IOException {
        try (InputStream stream = data.getStream();){
            FileUtilities.copyToFile((InputStream)stream, (File)templateFile);
        }
    }

    private String getSelectedContainingTemplateFolderResourceSuffix() {
        return this.getSelectedContainingTemplateFolder().getResourceSuffix();
    }

    private TemplateFolder getSelectedContainingTemplateFolder() {
        TemplateLocation selectedLocation = ScriptTemplateUtil.getSelectedTemplateLocation(this._templateComponent);
        return this.isTemplateResource(selectedLocation) ? selectedLocation.getParent() : (TemplateFolder)selectedLocation;
    }

    private boolean isTemplateResource(TemplateLocation selectedLocation) {
        return selectedLocation instanceof TemplateResource;
    }

    protected ZipImporter createImporter(BinaryData data) {
        return new ZipImporter(data){

            protected void importZipEntry(ZipInputStream zipStream, ZipEntry zipEntry) {
                try {
                    this.createZipEntryFile(zipStream, zipEntry);
                }
                catch (IOException exception) {
                    throw new IOError(exception);
                }
            }

            private File createZipEntryFile(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
                File file = this.getFile(zipEntry);
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                } else {
                    this.createZipEntryFile(zipInputStream, file);
                }
                return file;
            }

            private void createZipEntryFile(ZipInputStream zipInputStream, File file) throws IOException {
                file.getParentFile().mkdirs();
                if (file.createNewFile()) {
                    FileUtilities.copyToFile((InputStream)zipInputStream, (File)file);
                }
            }

            private File getFile(ZipEntry zipEntry) {
                return this.getTemplateRootFile(zipEntry.getName());
            }

            private File getTemplateRootFile(String entryName) {
                String resourceSuffixToTemplateRoot = ImportScriptRecorderTemplateCommand.this.createResourceSuffixToTemplateRoot(entryName);
                return new File(Workspace.topLevelWebapp(), ImportScriptRecorderTemplateCommand.this.getResourcePath(resourceSuffixToTemplateRoot));
            }
        };
    }
}

