/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.util.ResKey;
import com.top_logic.layout.component.Selectable;
import com.top_logic.layout.scripting.template.gui.templates.I18NConstants;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateLocation;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateResource;
import com.top_logic.layout.tree.model.TLTreeNode;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.execution.ExecutabilityRule;
import com.top_logic.tool.execution.ExecutableState;
import java.util.Map;

public class IsTemplateSelected
implements ExecutabilityRule {
    public static final IsTemplateSelected INSTANCE = new IsTemplateSelected();

    private IsTemplateSelected() {
    }

    public ExecutableState isExecutable(LayoutComponent aComponent, Object model, Map<String, Object> someValues) {
        Object selection = ((Selectable)aComponent).getSelected();
        if (!IsTemplateSelected.isTemplate(selection)) {
            return ExecutableState.createDisabledState((ResKey)I18NConstants.ERROR_NO_TEMPLATE_SELECTED);
        }
        return ExecutableState.EXECUTABLE;
    }

    public static boolean isTemplate(Object value) {
        return IsTemplateSelected.template(value) != null;
    }

    public static TemplateResource template(Object value) {
        if (!(value instanceof TLTreeNode)) {
            return null;
        }
        TLTreeNode node = (TLTreeNode)value;
        Object businessObject = node.getBusinessObject();
        if (!(businessObject instanceof TemplateLocation)) {
            return null;
        }
        TemplateLocation templateLocation = (TemplateLocation)businessObject;
        if (!templateLocation.isTemplate()) {
            return null;
        }
        return (TemplateResource)templateLocation;
    }
}

