/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.Settings;
import com.top_logic.basic.io.FileUtilities;
import com.top_logic.basic.io.binary.BinaryData;
import com.top_logic.basic.util.ResKey;
import com.top_logic.layout.form.CheckException;
import com.top_logic.layout.form.constraints.AbstractConstraint;
import com.top_logic.layout.form.model.DataField;
import com.top_logic.layout.scripting.template.gui.templates.I18NConstants;
import com.top_logic.template.xml.TemplateXMLParser;
import com.top_logic.template.xml.source.TemplateFilesystemSource;
import com.top_logic.template.xml.source.TemplateSource;
import com.top_logic.util.Resources;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ScriptRecorderTemplateConstraint
extends AbstractConstraint {
    private final String TMP_TEMPLATE_FILE_PREFIX = "checkScriptTemplate";
    private final TemplateXMLParser _templateXMLParser = new TemplateXMLParser();

    private File createTmpTemplateFile() throws IOError {
        try {
            File tmpDir = Settings.getInstance().getTempDir();
            return File.createTempFile("checkScriptTemplate", "", tmpDir);
        }
        catch (IOException exception) {
            throw new IOError(exception);
        }
    }

    public boolean check(Object value) throws CheckException {
        List items = DataField.toItems((Object)value);
        for (BinaryData item : items) {
            this.checkItem(item);
        }
        return true;
    }

    private void checkItem(BinaryData data) throws CheckException {
        try (InputStream stream = data.getStream();){
            if ("application/x-zip-compressed".equals(data.getContentType())) {
                this.checkZipFile(stream);
            } else {
                this.checkSingleScriptRecorderTemplate(stream);
            }
        }
        catch (IOException exception) {
            throw new IOError(exception);
        }
    }

    private void checkZipFile(InputStream stream) throws IOException, CheckException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(stream);
             ZipInputStream zipStream = new ZipInputStream(bufferedInputStream);){
            ZipEntry zipEntry = zipStream.getNextEntry();
            while (zipEntry != null) {
                this.checkValidZipEntry(zipStream, zipEntry);
                zipEntry = zipStream.getNextEntry();
            }
        }
    }

    private void checkValidZipEntry(ZipInputStream zipStream, ZipEntry zipEntry) throws IOException, CheckException {
        if (!zipEntry.isDirectory()) {
            this.checkSingleScriptRecorderTemplate(zipStream);
        }
    }

    private void checkSingleScriptRecorderTemplate(InputStream stream) throws IOError, IOException, CheckException {
        File tmpFile = this.createTmpTemplateFile();
        FileUtilities.copyToFile((InputStream)stream, (File)tmpFile);
        this.checkScriptRecorderTemplateFile(tmpFile);
    }

    private void checkScriptRecorderTemplateFile(File possibleTemplateFile) throws CheckException {
        try {
            this._templateXMLParser.parse((TemplateSource)new TemplateFilesystemSource(possibleTemplateFile));
        }
        catch (Exception exception) {
            ResKey noValidTemplateResKey = I18NConstants.NO_VALID_SCRIPT_RECORDER_TEMPLATE_FILE;
            throw new CheckException(Resources.getInstance().getString(noValidTemplateResKey));
        }
    }
}

