/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.UnreachableAssertion;
import com.top_logic.basic.xml.DOMUtil;
import com.top_logic.basic.xml.TagWriter;
import com.top_logic.basic.xml.XMLPrettyPrinter;
import com.top_logic.dob.MOAttribute;
import com.top_logic.dob.MetaObject;
import com.top_logic.dob.ex.UnknownTypeException;
import com.top_logic.dob.meta.DefaultTypeSystem;
import com.top_logic.dob.meta.MOStructure;
import com.top_logic.template.TemplateParseResult;
import com.top_logic.template.model.TemplateDataObject;
import com.top_logic.template.model.TemplateMOAttribute;
import com.top_logic.template.xml.ConfigurableExpansionModel;
import com.top_logic.template.xml.TemplateXMLParser;
import com.top_logic.template.xml.source.TemplateSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Template {
    private final MOStructure _type;
    private final ConfigurableExpansionModel _expansionModel;
    private final TemplateSource _source;
    private TemplateDataObject _parameterData;

    public Template(TemplateSource source, TemplateParseResult parseResult) {
        MOStructure type;
        DefaultTypeSystem types = new DefaultTypeSystem((Iterable)parseResult.getTypes());
        try {
            type = (MOStructure)types.getType("_this");
        }
        catch (UnknownTypeException ex) {
            throw new UnreachableAssertion((Throwable)ex);
        }
        HashMap<String, String> fakeValues = new HashMap<String, String>();
        for (MOAttribute attribute : type.getAttributes()) {
            if (((TemplateMOAttribute)attribute).hasDefaultValue()) continue;
            String fakeValue = attribute.isMandatory() ? "NONE" : null;
            fakeValues.put(attribute.getName(), fakeValue);
        }
        ConfigurableExpansionModel expansionModel = new ConfigurableExpansionModel(parseResult, fakeValues);
        this._source = source;
        this._type = type;
        this._expansionModel = expansionModel;
        this._parameterData = new TemplateDataObject((MetaObject)type);
    }

    public static Template load(TemplateSource source) throws IOException, XMLStreamException {
        TemplateParseResult parseResult = new TemplateXMLParser().parse(source);
        return new Template(source, parseResult);
    }

    public MOStructure getType() {
        return this._type;
    }

    public Iterable<? extends MOAttribute> getParameters() {
        return this._type.getAttributes();
    }

    public TemplateSource getSource() {
        return this._source;
    }

    public Object getDefaultValue(MOAttribute attribute) {
        return this._parameterData.getValue(attribute, this._expansionModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent(XMLPrettyPrinter.Config formatConfig) throws IOException, SAXException {
        StringWriter buffer = new StringWriter();
        XMLPrettyPrinter printer = new XMLPrettyPrinter((Writer)buffer, formatConfig);
        printer.getOut().setState(TagWriter.State.ELEMENT_CONTENT);
        try (InputStream in = this._source.getContent();){
            Document document = DOMUtil.getDocumentBuilder().parse(in);
            for (Element element : DOMUtil.elementsNS((Node)document.getDocumentElement(), (String)"http://www.top-logic.com/ns/template/1.0", (String)"body")) {
                for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                    printer.write(node);
                }
            }
        }
        return buffer.toString();
    }
}

