/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.StringServices;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.xml.DOMUtil;
import com.top_logic.basic.xml.XMLPrettyPrinter;
import com.top_logic.layout.DisplayContext;
import com.top_logic.layout.form.FormHandler;
import com.top_logic.layout.form.component.AbstractApplyCommandHandler;
import com.top_logic.layout.form.component.FormComponent;
import com.top_logic.layout.form.model.FormContext;
import com.top_logic.layout.form.values.edit.EditorFactory;
import com.top_logic.layout.scripting.template.gui.templates.AbstractTemplateFormBuilder;
import com.top_logic.layout.scripting.template.gui.templates.I18NConstants;
import com.top_logic.layout.scripting.template.gui.templates.TemplateEditModel;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateResource;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.template.xml.source.ResourceTransaction;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.boundsec.HandlerResult;
import com.top_logic.util.error.TopLogicException;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TemplateApplyCommand
extends AbstractCommandHandler {
    public TemplateApplyCommand(InstantiationContext context, AbstractCommandHandler.Config config) {
        super(context, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerResult handleCommand(DisplayContext aContext, LayoutComponent aComponent, Object model, Map<String, Object> someArguments) {
        Document document;
        FormHandler form = this.form(aComponent);
        boolean ok = form.getFormContext().checkAll();
        if (!ok) {
            return AbstractApplyCommandHandler.createErrorResult((FormContext)form.getFormContext());
        }
        TemplateEditModel editModel = this.getTemplateEditModel(aComponent);
        TemplateResource template = this.getTemplateResource(aComponent);
        String content = "<t:template xmlns:t='http://www.top-logic.com/ns/template/1.0'><t:head><t:settings output-format='xml' output-xml-header='false' /><t:parameters></t:parameters></t:head><t:body>" + editModel.getContent() + "</t:body></t:template>";
        try {
            document = DOMUtil.parse((String)content);
        }
        catch (IllegalArgumentException ex) {
            throw new TopLogicException(I18NConstants.ERROR_TEMPLATE_INVALID__ERROR.fill((Object)ex.getMessage()));
        }
        HashSet<String> names = new HashSet<String>();
        for (Element head : DOMUtil.elementsNS((Node)document.getDocumentElement(), (String)"http://www.top-logic.com/ns/template/1.0", (String)"head")) {
            Iterator iterator = DOMUtil.elementsNS((Node)head, (String)"http://www.top-logic.com/ns/template/1.0", (String)"parameters").iterator();
            if (!iterator.hasNext()) continue;
            Element parameters = (Element)iterator.next();
            for (TemplateEditModel.Parameter param : editModel.getParameters()) {
                String name = param.getName();
                if (!names.add(name)) {
                    throw new TopLogicException(I18NConstants.ERROR_DUPLICATE_PARAMETER__NAME.fill((Object)name));
                }
                Element paramElement = document.createElementNS("http://www.top-logic.com/ns/template/1.0", "parameter");
                paramElement.setAttributeNS(null, "name", name);
                String defaultValue = param.getDefault();
                if (!StringServices.isEmpty((CharSequence)defaultValue)) {
                    paramElement.setAttributeNS(null, "default", defaultValue);
                }
                paramElement.setAttributeNS(null, "type", "string");
                parameters.appendChild(paramElement);
            }
        }
        try (ResourceTransaction tx = template.update();){
            try (OutputStream out = tx.open();
                 XMLPrettyPrinter printer = new XMLPrettyPrinter(out, ((AbstractTemplateFormBuilder.Config)((FormComponent.Config)aComponent.getConfig()).getModelBuilder()).getXMLStorage());){
                printer.write((Node)document);
            }
            tx.commit();
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        aComponent.fireModelModifiedEvent((Object)template, (Object)aComponent);
        return HandlerResult.DEFAULT_RESULT;
    }

    protected final FormHandler form(LayoutComponent component) {
        return (FormHandler)component;
    }

    protected final TemplateEditModel getTemplateEditModel(LayoutComponent component) {
        return (TemplateEditModel)EditorFactory.getModel((FormHandler)this.form(component));
    }

    protected abstract TemplateResource getTemplateResource(LayoutComponent var1);
}

