/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.TypedConfiguration;
import com.top_logic.dob.MOAttribute;
import com.top_logic.layout.scripting.template.gui.templates.AbstractTemplateFormBuilder;
import com.top_logic.layout.scripting.template.gui.templates.I18NConstants;
import com.top_logic.layout.scripting.template.gui.templates.IsTemplateSelected;
import com.top_logic.layout.scripting.template.gui.templates.Template;
import com.top_logic.layout.scripting.template.gui.templates.TemplateEditModel;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateResource;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.util.error.TopLogicException;
import java.io.IOException;
import java.util.List;
import org.xml.sax.SAXException;

public class TemplateEditBuilder
extends AbstractTemplateFormBuilder<Object> {
    public TemplateEditBuilder(InstantiationContext context, AbstractTemplateFormBuilder.Config config) {
        super(context, config);
    }

    private AbstractTemplateFormBuilder.Config config() {
        return (AbstractTemplateFormBuilder.Config)this.getConfig();
    }

    protected Class<? extends Object> getModelType() {
        return Object.class;
    }

    protected void fillFormModel(TemplateEditModel formModel, Object businessModel) {
        TemplateResource templateResource = IsTemplateSelected.template(businessModel);
        if (templateResource == null) {
            return;
        }
        Template template = templateResource.tryLoad();
        formModel.setName(this.stripLeadingSlash(templateResource.getResourceSuffix()));
        List<TemplateEditModel.Parameter> parameters = formModel.getParameters();
        for (MOAttribute mOAttribute : template.getParameters()) {
            TemplateEditModel.Parameter parameter = (TemplateEditModel.Parameter)TypedConfiguration.newConfigItem(TemplateEditModel.Parameter.class);
            parameter.setName(mOAttribute.getName());
            parameter.setDefault((String)template.getDefaultValue(mOAttribute));
            parameters.add(parameter);
        }
        try {
            formModel.setContent(template.getContent(this.config().getXMLDisplay()));
        }
        catch (IOException | SAXException ex) {
            throw new TopLogicException(I18NConstants.ERROR_TEMPLATE_LOADING_FAILED__NAME_ERROR.fill((Object)templateResource.getName(), (Object)ex.getMessage()), (Throwable)ex);
        }
    }

    private String stripLeadingSlash(String resourceSuffix) {
        return this.stripLeading('/', resourceSuffix);
    }

    private String stripLeading(char ch, String s) {
        if (s != null && !s.isEmpty() && s.charAt(0) == ch) {
            return s.substring(1);
        }
        return s;
    }

    protected boolean modelSupported(Object model, LayoutComponent component) {
        return model == null || IsTemplateSelected.isTemplate(model);
    }
}

