/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.config.NamedConfigMandatory;
import com.top_logic.basic.config.annotation.Name;
import com.top_logic.basic.config.annotation.Nullable;
import com.top_logic.basic.config.constraint.algorithm.PropertyModel;
import com.top_logic.basic.config.constraint.algorithm.ValueConstraint;
import com.top_logic.basic.config.constraint.annotation.Constraint;
import com.top_logic.basic.config.constraint.annotation.RegexpConstraint;
import com.top_logic.basic.config.order.DisplayOrder;
import com.top_logic.layout.form.values.MultiLineText;
import com.top_logic.layout.form.values.edit.annotation.ControlProvider;
import com.top_logic.layout.form.values.edit.annotation.CssClass;
import com.top_logic.layout.scripting.template.gui.templates.I18NConstants;
import com.top_logic.layout.scripting.template.gui.templates.TabularParameterDisplay;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@DisplayOrder(value={"parameters", "content"})
public interface TemplateEditModel
extends NamedConfigMandatory {
    public static final String PARAMETERS = "parameters";
    public static final String CONTENT = "content";

    @Constraint(value=NameConstraint.class)
    public String getName();

    @ControlProvider(value=TabularParameterDisplay.class)
    @Name(value="parameters")
    public List<Parameter> getParameters();

    @ControlProvider(value=MultiLineText.class)
    @CssClass(value="scriptRecorderActionXmlField")
    @Name(value="content")
    public String getContent();

    public void setContent(String var1);

    public static class NameConstraint
    extends ValueConstraint<String> {
        private static final String SUFFIX = ".xml";
        private static final String INVALID_CHARS = "\\:*?\"<>|~'$&()";
        private static final Set<Integer> INVALID_CHARS_SET = NameConstraint.toSet("\\:*?\"<>|~'$&()");
        public static final NameConstraint INSTANCE = new NameConstraint();

        private NameConstraint() {
            super(String.class);
        }

        protected void checkValue(PropertyModel<String> propertyModel) {
            String[] parts;
            String value = (String)propertyModel.getValue();
            if (value.isEmpty()) {
                propertyModel.setProblemDescription(I18NConstants.ERROR_FILE_NAME_MUST_NOT_BE_EMPTY);
                return;
            }
            if (this.containsInvalidCharacters(value)) {
                propertyModel.setProblemDescription(I18NConstants.ERROR_FILE_NAME_MUST_NOT_CONTAIN__CHARS.fill((Object)INVALID_CHARS));
                return;
            }
            for (String part : parts = value.split("/", -1)) {
                if (part.isEmpty()) {
                    propertyModel.setProblemDescription(I18NConstants.ERROR_FILE_NAME_MUST_NOT_BE_EMPTY);
                    return;
                }
                if (part.startsWith(".")) {
                    propertyModel.setProblemDescription(I18NConstants.ERROR_FILE_NAME_MUST_NOT_START_WITH_DOT);
                    return;
                }
                if (!Character.isWhitespace(part.charAt(0)) && !Character.isWhitespace(part.charAt(part.length() - 1))) continue;
                propertyModel.setProblemDescription(I18NConstants.ERROR_FILE_NAME_MUST_NOT_START_OR_END_WITH_WHITE_SPACE);
                return;
            }
            if (!parts[parts.length - 1].endsWith(SUFFIX)) {
                propertyModel.setProblemDescription(I18NConstants.ERROR_FILE_NAME_MUST_END_IN__SUFFIX.fill((Object)SUFFIX));
                return;
            }
        }

        private boolean containsInvalidCharacters(CharSequence string) {
            return string.chars().anyMatch(this::isInvalidCharacter);
        }

        private boolean isInvalidCharacter(int character) {
            return character < 32 || character >= 127 || INVALID_CHARS_SET.contains(character);
        }

        private static Set<Integer> toSet(CharSequence string) {
            return string.chars().boxed().collect(Collectors.toSet());
        }
    }

    @DisplayOrder(value={"name", "default"})
    public static interface Parameter
    extends NamedConfigMandatory {
        public static final String DEFAULT = "default";

        @RegexpConstraint(value="[a-zA-Z_][a-zA-Z_0-9]*")
        public String getName();

        @Name(value="default")
        @Nullable
        public String getDefault();

        public void setDefault(String var1);
    }
}

