/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.StringServices;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.TypedConfiguration;
import com.top_logic.layout.DisplayContext;
import com.top_logic.layout.form.FormField;
import com.top_logic.layout.form.FormHandler;
import com.top_logic.layout.form.component.AbstractApplyCommandHandler;
import com.top_logic.layout.form.model.FormContext;
import com.top_logic.layout.scripting.recorder.ref.ModelName;
import com.top_logic.layout.scripting.recorder.ref.value.StringValue;
import com.top_logic.layout.scripting.template.action.ScriptTemplateAction;
import com.top_logic.layout.scripting.template.action.TemplateAction;
import com.top_logic.layout.scripting.template.gui.templates.IsTemplateSelected;
import com.top_logic.layout.scripting.template.gui.templates.Template;
import com.top_logic.layout.scripting.template.gui.templates.TemplateLocationResources;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateResource;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.tool.boundsec.AbstractCommandHandler;
import com.top_logic.tool.boundsec.HandlerResult;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TemplateInstantiationCommand
extends AbstractCommandHandler {
    public TemplateInstantiationCommand(InstantiationContext context, AbstractCommandHandler.Config config) {
        super(context, config);
    }

    public HandlerResult handleCommand(DisplayContext aContext, LayoutComponent aComponent, Object model, Map<String, Object> someArguments) {
        FormHandler formHandler = (FormHandler)aComponent;
        FormContext formContext = formHandler.getFormContext();
        boolean ok = formContext.checkAll();
        if (!ok) {
            return AbstractApplyCommandHandler.createErrorResult((FormContext)formContext);
        }
        TemplateResource templateResource = IsTemplateSelected.template(model);
        ScriptTemplateAction action = (ScriptTemplateAction)TypedConfiguration.newConfigItem(ScriptTemplateAction.class);
        action.setTemplate("script:" + templateResource.getResourceSuffix());
        action.setTemplateNameComment(TemplateLocationResources.INSTANCE.getLabel(templateResource));
        Template template = templateResource.tryLoad();
        List<TemplateAction.Parameter> parameters = action.getParameters();
        Iterator it = formContext.getFields();
        while (it.hasNext()) {
            String value;
            FormField field = (FormField)it.next();
            if (!template.getType().hasAttribute(field.getName()) || StringServices.isEmpty((CharSequence)(value = (String)field.getValue()))) continue;
            TemplateAction.Parameter parameter = (TemplateAction.Parameter)TypedConfiguration.newConfigItem(TemplateAction.Parameter.class);
            parameter.setName(field.getName());
            StringValue valueRef = (StringValue)TypedConfiguration.newConfigItem(StringValue.class);
            valueRef.setString(value);
            parameter.setValue((ModelName)valueRef);
            parameters.add(parameter);
        }
        aComponent.fireModelCreatedEvent((Object)action, (Object)aComponent);
        return HandlerResult.DEFAULT_RESULT;
    }
}

