/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.StringServices;
import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.generate.CodeUtil;
import com.top_logic.dob.MOAttribute;
import com.top_logic.layout.form.FormMember;
import com.top_logic.layout.form.component.FormComponent;
import com.top_logic.layout.form.model.FormContext;
import com.top_logic.layout.form.model.FormFactory;
import com.top_logic.layout.form.model.StringField;
import com.top_logic.layout.scripting.template.gui.templates.I18NConstants;
import com.top_logic.layout.scripting.template.gui.templates.IsTemplateSelected;
import com.top_logic.layout.scripting.template.gui.templates.Template;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateResource;
import com.top_logic.mig.html.layout.LayoutComponent;
import com.top_logic.template.model.TemplateMOAttribute;
import com.top_logic.util.Resources;
import java.util.List;

public class TemplateParameterComponent
extends FormComponent {
    private Template _template;

    public TemplateParameterComponent(InstantiationContext context, FormComponent.Config config) throws ConfigurationException {
        super(context, config);
    }

    public FormContext createFormContext() {
        if (this._template == null) {
            return null;
        }
        FormContext result = new FormContext((LayoutComponent)this);
        List attributes = this._template.getType().getAttributes();
        if (attributes.isEmpty()) {
            result.addMember((FormMember)FormFactory.newDisplayField((String)"info", (Object)I18NConstants.NO_TEMPLATE_PARAMETERS));
        } else {
            for (MOAttribute attribute : attributes) {
                StringField field = FormFactory.newStringField((String)attribute.getName());
                String label = CodeUtil.toUpperCaseStart((String)attribute.getName());
                if (((TemplateMOAttribute)attribute).hasDefaultValue()) {
                    Object defaultValue = this._template.getDefaultValue(attribute);
                    label = StringServices.isEmpty((Object)defaultValue) ? Resources.getInstance().getString(I18NConstants.EMPLTY_DEFAULT_LABEL__LABEL.fill((Object)label)) : Resources.getInstance().getString(I18NConstants.DEFAULT_LABEL__LABEL_DEFAULT.fill((Object)label, defaultValue));
                } else {
                    field.setMandatory(true);
                }
                field.setLabel(label);
                result.addMember((FormMember)field);
            }
        }
        return result;
    }

    protected void handleNewModel(Object newModel) {
        super.handleNewModel(newModel);
        this.removeFormContext();
        this.loadTemplate(newModel);
    }

    private void loadTemplate(Object model) {
        TemplateResource templateResource = IsTemplateSelected.template(model);
        this._template = templateResource == null ? null : templateResource.tryLoad();
    }

    protected boolean supportsInternalModel(Object object) {
        return IsTemplateSelected.isTemplate(object);
    }
}

