/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates;

import com.top_logic.basic.FileManager;
import com.top_logic.basic.Logger;
import com.top_logic.basic.config.ConfiguredInstance;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.PolymorphicConfiguration;
import com.top_logic.basic.config.annotation.Mandatory;
import com.top_logic.basic.io.FileUtilities;
import com.top_logic.layout.scripting.template.gui.templates.IsTemplateSelected;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateFolder;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateLocation;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateResource;
import com.top_logic.layout.tree.component.TreeModelBuilder;
import com.top_logic.layout.tree.component.TreeNodeBasedTreeModelBuilder;
import com.top_logic.layout.tree.model.DefaultMutableTLTreeNode;
import com.top_logic.layout.tree.model.MutableTLTreeNode;
import com.top_logic.layout.tree.model.StructureTreeModel;
import com.top_logic.layout.tree.model.TLTreeNode;
import com.top_logic.mig.html.layout.LayoutComponent;
import java.io.IOException;

public class TemplateTreeBuilder
extends TreeNodeBasedTreeModelBuilder<DefaultMutableTLTreeNode>
implements ConfiguredInstance<Config> {
    private final Config _config;
    private String _templateRootResourcePath;

    public TemplateTreeBuilder(InstantiationContext context, Config config) {
        this._config = config;
        this._templateRootResourcePath = this.getTemplateRootResourcePath(config);
    }

    private String getTemplateRootResourcePath(Config config) {
        String resourcePath = config.getTemplatePath();
        if (!resourcePath.isEmpty() && resourcePath.charAt(resourcePath.length() - 1) != '/') {
            return resourcePath + "/";
        }
        return resourcePath;
    }

    public Config getConfig() {
        return this._config;
    }

    public Object getModel(Object businessModel, LayoutComponent aComponent) {
        StructureTreeModel model = new StructureTreeModel(null);
        try {
            this.buildTemplateTree((MutableTLTreeNode<?>)model.getRoot());
        }
        catch (IOException ex) {
            Logger.error((String)"Failed to build template tree.", (Throwable)ex, TemplateTreeBuilder.class);
        }
        return model.getRoot();
    }

    private void buildTemplateTree(MutableTLTreeNode<?> parent) throws IOException {
        if (FileManager.getInstance().isDirectory(this._templateRootResourcePath)) {
            TemplateFolder folder = new TemplateFolder("");
            parent.setBusinessObject((Object)folder);
            folder.initLocation((TLTreeNode<?>)parent);
            this.scanFolder(parent, this._templateRootResourcePath);
        }
    }

    private void scanFolder(MutableTLTreeNode<?> parent, String resourcePath) throws IOException {
        FileManager fileManager = FileManager.getInstance();
        for (String path : fileManager.getResourcePaths(resourcePath)) {
            String contentResource = path.substring(this._templateRootResourcePath.length());
            String fileName = FileUtilities.getFilenameOfResource((String)contentResource);
            if (fileName.startsWith(".")) continue;
            MutableTLTreeNode contentNode = this.findNode(parent, fileName);
            if (fileManager.isDirectory(path)) {
                if (contentNode != null && !this.isFolder(contentNode)) {
                    parent.removeChild(parent.getIndex(contentNode));
                    contentNode = null;
                }
                if (contentNode == null) {
                    TemplateFolder folder = new TemplateFolder(contentResource);
                    contentNode = parent.createChild((Object)folder);
                    folder.initLocation((TLTreeNode<?>)contentNode);
                }
                this.scanFolder(contentNode, path);
                if (contentNode.getChildCount() != 0) continue;
                parent.removeChild(parent.getIndex((Object)contentNode));
                continue;
            }
            if (!fileName.endsWith(".xml")) continue;
            if (contentNode != null && !this.isTemplate(contentNode)) {
                parent.removeChild(parent.getIndex((Object)contentNode));
                contentNode = null;
            }
            TemplateResource template = new TemplateResource(contentResource);
            if (contentNode == null) {
                contentNode = parent.createChild((Object)template);
            } else {
                contentNode.setBusinessObject((Object)template);
            }
            template.initLocation((TLTreeNode<?>)contentNode);
        }
    }

    public String getTemplateRootResourcePath() {
        return this._templateRootResourcePath;
    }

    private boolean isTemplate(MutableTLTreeNode<?> node) {
        return IsTemplateSelected.isTemplate(node);
    }

    private boolean isFolder(MutableTLTreeNode<?> node) {
        return !this.isTemplate(node);
    }

    private MutableTLTreeNode<?> findNode(MutableTLTreeNode<?> parent, String name) {
        for (MutableTLTreeNode node : parent.getChildren()) {
            if (!((TemplateLocation)node.getBusinessObject()).getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public boolean supportsModel(Object aModel, LayoutComponent aComponent) {
        return aModel instanceof DefaultMutableTLTreeNode;
    }

    public Object retrieveModelFromNode(LayoutComponent contextComponent, DefaultMutableTLTreeNode node) {
        return node.getBusinessObject();
    }

    public boolean supportsNode(LayoutComponent contextComponent, Object node) {
        return node instanceof DefaultMutableTLTreeNode;
    }

    public static interface Config
    extends PolymorphicConfiguration<TreeModelBuilder<?>> {
        @Mandatory
        public String getTemplatePath();
    }
}

