/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates.node;

import com.top_logic.basic.io.FileUtilities;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateFolder;
import com.top_logic.layout.tree.model.TLTreeNode;

public abstract class TemplateLocation {
    private final String _name;
    private TLTreeNode<?> _node;
    private final String _resourceSuffix;

    public TemplateLocation(String resourceSuffix) {
        this._resourceSuffix = resourceSuffix;
        this._name = FileUtilities.getFilenameOfResource((String)resourceSuffix);
    }

    public void initLocation(TLTreeNode<?> node) {
        this._node = node;
    }

    public String getResourceSuffix() {
        return this._resourceSuffix;
    }

    public String getName() {
        return this._name;
    }

    public abstract boolean isTemplate();

    public TemplateFolder getParent() {
        if (this._node == null) {
            return null;
        }
        TLTreeNode parentNode = this._node.getParent();
        if (parentNode == null) {
            return null;
        }
        return (TemplateFolder)parentNode.getBusinessObject();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._resourceSuffix == null ? 0 : this._resourceSuffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateLocation other = (TemplateLocation)obj;
        return !(this._resourceSuffix == null ? other._resourceSuffix != null : !this._resourceSuffix.equals(other._resourceSuffix));
    }
}

