/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.layout.scripting.template.gui.templates.node;

import com.top_logic.layout.scripting.template.gui.templates.I18NConstants;
import com.top_logic.layout.scripting.template.gui.templates.Template;
import com.top_logic.layout.scripting.template.gui.templates.node.TemplateLocation;
import com.top_logic.template.xml.source.ResourceTransaction;
import com.top_logic.template.xml.source.TemplateSource;
import com.top_logic.template.xml.source.TemplateSourceFactory;
import com.top_logic.util.error.TopLogicException;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class TemplateResource
extends TemplateLocation {
    public TemplateResource(String resourceSuffix) {
        super(resourceSuffix);
    }

    @Override
    public boolean isTemplate() {
        return true;
    }

    public TemplateSource getSource() {
        return TemplateSourceFactory.getInstance().resolve("script:" + this.getResourceSuffix());
    }

    public Template load() throws IOException, XMLStreamException {
        return Template.load(this.getSource());
    }

    public Template tryLoad() throws TopLogicException {
        try {
            return this.load();
        }
        catch (IOException | XMLStreamException ex) {
            throw new TopLogicException(I18NConstants.ERROR_TEMPLATE_LOADING_FAILED__NAME_ERROR.fill((Object)this.getName(), (Object)ex.getMessage()));
        }
    }

    public ResourceTransaction update() throws IOException {
        return this.getSource().update();
    }

    public void delete() throws IOException {
        this.getSource().delete();
    }
}

